/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.api.helpers;

import com.google.common.primitives.Ints;

public class Index
extends Number
implements Comparable<Index> {
    private static final long serialVersionUID = 2L;
    public final int value;
    public final int offset;

    private Index(int value, int offset) {
        this.value = value;
        this.offset = offset;
    }

    public static Index fromJava(int zeroBasedValue, int offset) {
        return new Index(zeroBasedValue, offset);
    }

    public static Index toJava(int nonZeroBasedValue, int offset) {
        return new Index(nonZeroBasedValue - offset, offset);
    }

    @Override
    public int intValue() {
        return this.value + this.offset;
    }

    @Override
    public long longValue() {
        return (long)this.value + (long)this.offset;
    }

    @Override
    public float floatValue() {
        return (float)this.value + (float)this.offset;
    }

    @Override
    public double doubleValue() {
        return (double)this.value + (double)this.offset;
    }

    public boolean equals(Object obj) {
        return obj instanceof Index && this.value == ((Index)obj).value;
    }

    @Override
    public int compareTo(Index other) {
        return Ints.compare((int)this.value, (int)other.value);
    }

    public int hashCode() {
        return Ints.hashCode((int)this.value);
    }

    public String toString() {
        return Integer.toString(this.value + this.offset);
    }

    public void checkElementIndex(String name, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size: " + size);
        }
        if (this.value < 0) {
            throw new IndexOutOfBoundsException(String.format("%s (%d) must be at least %d", name, this.value + this.offset, this.offset));
        }
        if (this.value >= size) {
            throw new IndexOutOfBoundsException(String.format("%s (%d) must be less than %d", name, this.value + this.offset, size + this.offset));
        }
    }

    public void checkElementIndex(int size) {
        this.checkElementIndex("index", size);
    }
}

