/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import openperipheral.api.adapter.IScriptType;

public class NamedTupleType
implements IScriptType {
    public static TupleField TAIL = new TupleField(){

        public String toString() {
            return "...";
        }
    };
    public final List<TupleField> fields;

    public NamedTupleType(TupleField ... fields) {
        this.fields = ImmutableList.copyOf((Object[])fields);
    }

    public NamedTupleType(Collection<TupleField> fields) {
        this.fields = ImmutableList.copyOf(fields);
    }

    @Override
    public String describe() {
        return "{" + Joiner.on((String)",").join(this.fields) + "}";
    }

    public static class NamedTupleField
    extends TupleField {
        public final String name;
        public final IScriptType type;
        public final boolean isOptional;

        public NamedTupleField(String name, IScriptType type, boolean isOptional) {
            this.name = name;
            this.type = type;
            this.isOptional = isOptional;
        }

        public String toString() {
            return this.name + ":" + this.type.describe() + (this.isOptional ? "?" : "");
        }
    }

    public static class TupleField {
    }
}

