/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import openperipheral.adapter.property.IIndexedFieldManipulator;
import openperipheral.adapter.property.IIndexedPropertyAccessHandler;
import openperipheral.adapter.property.IPropertyExecutor;
import openperipheral.adapter.property.IndexedTypeInfo;
import openperipheral.adapter.property.PropertyUtils;
import openperipheral.api.converter.IConverter;
import openperipheral.converter.TypeConverter;
import org.apache.commons.lang3.ArrayUtils;

public class IndexedSetterExecutor
implements IPropertyExecutor {
    private final Field field;
    private final IIndexedFieldManipulator manipulator;
    private final IndexedTypeInfo typeInfo;
    private final IIndexedPropertyAccessHandler accessHandler;
    private final boolean nullable;

    public IndexedSetterExecutor(Field field, IIndexedFieldManipulator manipulator, IndexedTypeInfo typeInfo, IIndexedPropertyAccessHandler accessHandler, boolean nullable) {
        this.field = field;
        this.manipulator = manipulator;
        this.typeInfo = typeInfo;
        this.accessHandler = accessHandler;
        this.nullable = nullable;
    }

    @Override
    public Object[] call(IConverter converter, Object owner, Object ... args) {
        Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)"Setter must have exactly two arguments (value and index)");
        Object value = args[0];
        Object key = args[1];
        Type keyType = this.typeInfo.keyType;
        Object convertedKey = converter.toJava(key, keyType);
        Preconditions.checkArgument((convertedKey != null ? 1 : 0) != 0, (String)"Failed to convert index to type %s", (Object[])new Object[]{keyType});
        Object target = PropertyUtils.getContents(owner, this.field);
        Type valueType = this.typeInfo.getValueType(target, convertedKey);
        Object convertedValue = TypeConverter.nullableToJava(converter, this.nullable, value, valueType);
        this.accessHandler.onSet(owner, target, this.field, convertedKey, convertedValue);
        this.manipulator.setField(owner, target, this.field, convertedKey, convertedValue);
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }
}

