/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.util;

import cofh.lib.util.helpers.StringHelper;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.setup.FuelType;
import tonius.simplyjetpacks.setup.ParticleType;

public abstract class SJStringHelper {
    private static final DecimalFormat formatter = new DecimalFormat("###,###");

    public static String getFormattedNumber(int number) {
        return formatter.format(number);
    }

    public static String getTierText(int tier) {
        return String.format(SJStringHelper.localize("tooltip.tier", new Object[0]), tier);
    }

    public static String getFuelText(FuelType fuelType, int amount, int max, boolean infinite) {
        if (infinite) {
            return "\u00a77" + SJStringHelper.localize("tooltip.fuel.infinite." + fuelType.toString().toLowerCase(), new Object[0]);
        }
        return "\u00a77" + SJStringHelper.getFormattedNumber(amount) + " / " + SJStringHelper.getFormattedNumber(max) + fuelType.suffix;
    }

    public static String getStateText(boolean state) {
        String onOrOff = state ? "\u00a7a" + SJStringHelper.localize("tooltip.on", new Object[0]) : "\u00a7c" + SJStringHelper.localize("tooltip.off", new Object[0]);
        return "\u00a76" + SJStringHelper.localize("tooltip.state", new Object[0]) + ": " + onOrOff;
    }

    public static String getHoverModeText(boolean state) {
        String enabledOrDisabled = state ? "\u00a7a" + SJStringHelper.localize("tooltip.enabled", new Object[0]) : "\u00a7c" + SJStringHelper.localize("tooltip.disabled", new Object[0]);
        return "\u00a76" + SJStringHelper.localize("tooltip.hoverMode", new Object[0]) + ": " + enabledOrDisabled;
    }

    public static String getChargerStateText(boolean state) {
        String onOrOff = state ? "\u00a7a" + SJStringHelper.localize("tooltip.enabled", new Object[0]) : "\u00a7c" + SJStringHelper.localize("tooltip.disabled", new Object[0]);
        return "\u00a76" + SJStringHelper.localize("tooltip.chargerState", new Object[0]) + ": " + onOrOff;
    }

    public static String getFuelFluidText(String fluidName) {
        fluidName = SJStringHelper.localize(FluidRegistry.getFluid((String)fluidName).getUnlocalizedName(), false, (Object[])null);
        return "\u00a76" + SJStringHelper.localize("tooltip.fuelFluid", new Object[0]) + ": " + "\u00a77" + fluidName;
    }

    public static String getFuelUsageText(FuelType fuelType, int usage) {
        String usageText = SJStringHelper.getFormattedNumber(usage) + fuelType.suffix + "/t";
        return "\u00a76" + SJStringHelper.localize("tooltip.fuelUsage", new Object[0]) + ": " + "\u00a77" + usageText;
    }

    public static String getChargerRateText(int rate) {
        String rateText = rate > 0 ? SJStringHelper.getFormattedNumber(rate) + " RF/t" : SJStringHelper.localize("tooltip.energy.none", new Object[0]);
        return "\u00a76" + SJStringHelper.localize("tooltip.chargerRate", new Object[0]) + ": " + "\u00a77" + rateText;
    }

    public static String getEnergySendText(int send) {
        return "\u00a76" + SJStringHelper.localize("tooltip.energySend", new Object[0]) + ": " + "\u00a77" + SJStringHelper.getFormattedNumber(send) + " RF/t";
    }

    public static String getEnergyReceiveText(int receive) {
        String usageText = receive < Integer.MAX_VALUE ? SJStringHelper.getFormattedNumber(receive) + " RF/t" : SJStringHelper.localize("tooltip.energy.none", new Object[0]);
        return "\u00a76" + SJStringHelper.localize("tooltip.energyReceive", new Object[0]) + ": " + "\u00a77" + usageText;
    }

    public static String getParticlesText(ParticleType particle) {
        return "\u00a76" + SJStringHelper.localize("tooltip.particles", new Object[0]) + ": " + "\u00a77" + SJStringHelper.localize("tooltip.particles." + particle.ordinal(), new Object[0]);
    }

    public static String getPackGUIText(String key) {
        return "\u00a7b\u00a7o" + SJStringHelper.localize("tooltip.packGUIKey", key);
    }

    public static String getHUDFuelText(String prefix, int percent, FuelType fuelType, int fuel) {
        String text = "";
        if (!Config.minimalFuelHUD) {
            text = text + SJStringHelper.localize("gui.hud." + prefix + ".fuel", new Object[0]) + ": ";
        }
        text = percent > 0 ? text + SJStringHelper.getColoredPercent(percent) + "%" : text + "\u00a74" + SJStringHelper.localize("gui.hud.fuel.depleted", new Object[0]);
        if (Config.showExactFuelInHUD) {
            text = text + " (" + SJStringHelper.getFormattedNumber(fuel) + fuelType.suffix + ")";
        }
        return text;
    }

    public static String getHUDStateText(Boolean engine, Boolean hover, Boolean charger) {
        String text = "";
        if (engine != null) {
            text = text + (engine != false ? "\u00a7a" : "\u00a74") + SJStringHelper.localize("gui.hud.state.engine", new Object[0]) + "\u00a7r";
        }
        if (hover != null) {
            if (engine != null) {
                text = text + "\u00a77 - ";
            }
            text = text + (hover != false ? "\u00a7a" : "\u00a74") + SJStringHelper.localize("gui.hud.state.hover", new Object[0]) + "\u00a7r";
        }
        if (charger != null) {
            if (hover != null || engine != null) {
                text = text + "\u00a77 - ";
            }
            text = text + (charger != false ? "\u00a7a" : "\u00a74") + SJStringHelper.localize("gui.hud.state.charger", new Object[0]);
        }
        return text;
    }

    public static String getColoredPercent(int percent) {
        if (percent > 70) {
            return "\u00a7a" + percent;
        }
        if (percent > 40 && percent <= 70) {
            return "\u00a7e" + percent;
        }
        if (percent > 10 && percent <= 40) {
            return "\u00a76" + percent;
        }
        return "\u00a7c" + percent;
    }

    public static String getShiftText() {
        return "\u00a77" + String.format(SJStringHelper.localize("tooltip.holdShift", new Object[0]), "\u00a7e\u00a7o" + SJStringHelper.localize("tooltip.holdShift.shift", new Object[0]) + "\u00a7r" + "\u00a77");
    }

    public static boolean canShowDetails() {
        return !Config.holdShiftForDetails || StringHelper.isShiftKeyDown();
    }

    public static String localize(String unlocalized, Object ... args) {
        return SJStringHelper.localize(unlocalized, true, args);
    }

    public static String localize(String unlocalized, boolean prefix, Object ... args) {
        String toLocalize = (prefix ? "simplyjetpacks." : "") + unlocalized;
        if (args != null && args.length > 0) {
            return StatCollector.func_74837_a((String)toLocalize, (Object[])args);
        }
        return StatCollector.func_74838_a((String)toLocalize);
    }

    public static void addDescriptionLines(List<String> list, String base, String color) {
        String localized;
        String unlocalized;
        int i = 1;
        while (!(unlocalized = "simplyjetpacks.tooltip." + base + ".description." + i).equals(localized = StatCollector.func_74838_a((String)unlocalized))) {
            list.add(color + localized);
            ++i;
        }
    }

    public static void addDescriptionLines(List<String> list, String base) {
        SJStringHelper.addDescriptionLines(list, base, "");
    }
}

