/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.ArrayMappingUtils;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.gen.structure.MapGenScatteredFeatureMyst;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkProviderMyst
implements IChunkProvider {
    private AgeController controller;
    private Random rand;
    private NoiseGeneratorPerlin stoneNoiseGen;
    private World worldObj;
    private AgeData agedata;
    private double[] stoneNoise;
    private BiomeGenBase[] biomesForGeneration;
    private MapGenScatteredFeatureMyst scatteredFeatureGenerator = new MapGenScatteredFeatureMyst();
    private WorldGenMinable worldgenminablequartz = new WorldGenMinable(Blocks.field_150449_bY, 13, Blocks.field_150424_aL);
    private Block[] vblocks;
    private byte[] vmetadata;

    public ChunkProviderMyst(AgeController ageController, World world, AgeData age) {
        this.controller = ageController;
        this.stoneNoise = new double[256];
        this.worldObj = world;
        this.agedata = age;
        this.rand = new Random(this.agedata.getSeed());
        this.stoneNoiseGen = new NoiseGeneratorPerlin(this.rand, 4);
    }

    private void replaceBlocksForBiome(int chunkX, int chunkZ, Block[] blocks, byte[] metadata, BiomeGenBase[] abiomegenbase) {
        if (this.vblocks == null || this.vblocks.length != blocks.length) {
            this.vblocks = new Block[blocks.length];
        }
        if (this.vmetadata == null || this.vmetadata.length != metadata.length) {
            this.vmetadata = new byte[metadata.length];
        }
        ArrayMappingUtils.mapLocalToVanilla(blocks, this.vblocks);
        ArrayMappingUtils.mapLocalToVanilla(metadata, this.vmetadata);
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, chunkX, chunkZ, this.vblocks, this.vmetadata, abiomegenbase, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DENY) {
            double noisefactor = 0.03125;
            this.stoneNoise = this.stoneNoiseGen.func_151599_a(this.stoneNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, noisefactor * 2.0, noisefactor * 2.0, 1.0);
            for (int xoff = 0; xoff < 16; ++xoff) {
                for (int zoff = 0; zoff < 16; ++zoff) {
                    BiomeGenBase biomegenbase = abiomegenbase[zoff + xoff * 16];
                    biomegenbase.func_150573_a(this.worldObj, this.rand, this.vblocks, this.vmetadata, chunkX * 16 + xoff, chunkZ * 16 + zoff, this.stoneNoise[zoff + xoff * 16]);
                }
            }
        }
        ArrayMappingUtils.mapVanillaToLocal(this.vblocks, blocks);
        ArrayMappingUtils.mapVanillaToLocal(this.vmetadata, metadata);
    }

    public Chunk func_73158_c(int i, int j) {
        return this.func_73154_d(i, j);
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        Block[] blocks = new Block[65536];
        byte[] metadata = new byte[blocks.length];
        this.controller.generateTerrain(chunkX, chunkZ, blocks, metadata);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBlocksForBiome(chunkX, chunkZ, blocks, metadata, this.biomesForGeneration);
        this.controller.modifyTerrain(chunkX, chunkZ, blocks, metadata);
        this.scatteredFeatureGenerator.func_151539_a(this, this.worldObj, chunkX, chunkZ, null);
        Chunk chunk = new Chunk(this.worldObj, chunkX, chunkZ);
        this.mapBlocksToChunk(chunk, blocks, metadata);
        chunk.func_76603_b();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 128; ++y) {
                    chunk.func_76633_a(EnumSkyBlock.Block, x, y, z, 0);
                }
            }
        }
        this.controller.finalizeChunk(chunk, chunkX, chunkZ);
        return chunk;
    }

    private void mapBlocksToChunk(Chunk chunk, Block[] blocks, byte[] metadata) {
        ExtendedBlockStorage[] storageArrays = new ExtendedBlockStorage[16];
        int layers = blocks.length / 256;
        boolean flag = !this.worldObj.field_73011_w.field_76576_e;
        for (int y = 0; y < layers; ++y) {
            int storagei = y >> 4;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int coords = y << 8 | z << 4 | x;
                    Block block = blocks[coords];
                    if (block == null || block == Blocks.field_150350_a) continue;
                    if (storageArrays[storagei] == null) {
                        storageArrays[storagei] = new ExtendedBlockStorage(storagei << 4, flag);
                    }
                    storageArrays[storagei].func_150818_a(x, y & 0xF, z, block);
                    storageArrays[storagei].func_76654_b(x, y & 0xF, z, (int)metadata[coords]);
                }
            }
        }
        chunk.func_76602_a(storageArrays);
    }

    public boolean func_73149_a(int i, int j) {
        try {
            throw new RuntimeException("Something has called chunkExists on the lower-level generation logic. This is a logic error.  Please report this if you see it.");
        }
        catch (Exception e) {
            LoggerUtils.warn(e.getLocalizedMessage(), new Object[0]);
            e.printStackTrace();
            return false;
        }
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int chunkX, int chunkZ) {
        Chunk chunk = this.worldObj.func_72964_e(chunkX, chunkZ);
        chunk.field_76646_k = false;
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72959_q().func_76935_a(x + 16, z + 16);
        this.rand.setSeed(this.agedata.getSeed());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * l1 + (long)chunkZ * l2 ^ this.agedata.getSeed());
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(ichunkprovider, this.worldObj, this.rand, chunkX, chunkZ, false));
        try {
            biomegenbase.func_76728_a(this.worldObj, this.rand, x, z);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Biome [%s] threw an error while populating chunk.", biomegenbase.field_76791_y), e);
        }
        this.scatteredFeatureGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        this.controller.populate(this.worldObj, this.rand, x, z);
        boolean doGen = TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.worldgenminablequartz, (int)x, (int)z, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.QUARTZ);
        for (int k1 = 0; doGen && k1 < 16; ++k1) {
            int gx = x + this.rand.nextInt(16);
            int gy = this.rand.nextInt(108) + 10;
            int gz = z + this.rand.nextInt(16);
            this.worldgenminablequartz.func_76484_a(this.worldObj, this.rand, gx, gy, gz);
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                int j4 = this.worldObj.func_72874_g(x + i2, z + j3);
                if (this.worldObj.func_72884_u(i2 + x, j4 - 1, j3 + z)) {
                    this.worldObj.func_147465_d(i2 + x, j4 - 1, j3 + z, Blocks.field_150432_aD, 0, 2);
                }
                if (!this.worldObj.func_147478_e(i2 + x, j4, j3 + z, false)) continue;
                this.worldObj.func_147465_d(i2 + x, j4, j3 + z, Blocks.field_150431_aC, 0, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(ichunkprovider, this.worldObj, this.rand, chunkX, chunkZ, false));
        BlockFalling.field_149832_M = false;
        chunk.field_76646_k = true;
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType enumcreaturetype, int i, int j, int k) {
        List list = null;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(i, k);
        if (biomegenbase != null) {
            list = biomegenbase.func_76747_a(enumcreaturetype);
        }
        return this.controller.affectCreatureList(enumcreaturetype, list, i, j, k);
    }

    public ChunkPosition func_147416_a(World world, String s, int i, int j, int k) {
        return this.controller.locateTerrainFeature(world, s, i, j, k);
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int var1, int var2) {
        this.scatteredFeatureGenerator.func_151539_a(this, this.worldObj, var1, var2, null);
    }

    public void func_104112_b() {
    }
}

