/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.tileentity;

import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.inventory.IItemBuilder;
import com.xcompwiz.mystcraft.inventory.InventoryFolder;
import com.xcompwiz.mystcraft.item.ItemAgebook;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.tileentity.TileEntityRotatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityBookBinder
extends TileEntityRotatable
implements IItemBuilder,
ISidedInventory {
    private ItemStack[] itemstacks = new ItemStack[2];
    private List<ItemStack> pages = new ArrayList<ItemStack>();
    private String pendingtitle;
    private static int[] isidedslots = new int[]{1};

    @Override
    public void setYaw(int rotation) {
        rotation -= rotation % 90;
        super.setYaw(rotation);
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return slotIndex == 1 && this.isValidCover(itemstack);
    }

    private boolean isValidCover(ItemStack itemstack) {
        if (itemstack.func_77973_b() == Items.field_151116_aA) {
            return true;
        }
        return itemstack.func_77973_b() == ModItems.folder && InventoryFolder.getLargestSlotId(itemstack) == -1;
    }

    public int func_70302_i_() {
        return this.itemstacks.length + this.pages.size();
    }

    public ItemStack func_70301_a(int i) {
        if (i >= this.itemstacks.length) {
            if ((i -= this.itemstacks.length) >= this.pages.size()) {
                return null;
            }
            return this.pages.get(i);
        }
        return this.itemstacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.itemstacks[i] != null) {
            if (this.itemstacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.itemstacks[i];
                this.itemstacks[i] = null;
                this.handleItemChange(this.itemstacks[i], i);
                return itemstack;
            }
            ItemStack itemstack1 = this.itemstacks[i].func_77979_a(j);
            if (this.itemstacks[i].field_77994_a == 0) {
                this.itemstacks[i] = null;
            }
            this.handleItemChange(this.itemstacks[i], i);
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (itemstack != null && !this.func_94041_b(i, itemstack)) {
            itemstack.field_77994_a = 0;
            return;
        }
        this.itemstacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.handleItemChange(this.itemstacks[i], i);
    }

    public String func_145825_b() {
        return "Bookbinder";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTUtils.readInventoryArray(nbttagcompound.func_150295_c("Items", 10), this.itemstacks);
        this.pages.clear();
        NBTUtils.readItemStackCollection(nbttagcompound.func_150295_c("Pages", 10), this.pages);
        SymbolRemappings.remap(this.pages);
        if (nbttagcompound.func_74764_b("PendingTitle")) {
            this.pendingtitle = nbttagcompound.func_74779_i("PendingTitle");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.itemstacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (ItemStack page : this.pages) {
            NBTTagCompound itemdata = new NBTTagCompound();
            page.func_77955_b(itemdata);
            nbttaglist.func_74742_a((NBTBase)itemdata);
        }
        nbttagcompound.func_74782_a("Pages", (NBTBase)nbttaglist);
        if (this.pendingtitle != null) {
            nbttagcompound.func_74778_a("PendingTitle", this.pendingtitle);
        }
    }

    protected void handleItemChange(ItemStack itemstack, int slot) {
    }

    public String getPendingTitle() {
        return this.pendingtitle == null ? "" : this.pendingtitle;
    }

    public void setBookTitle(String name) {
        this.pendingtitle = name;
    }

    @Override
    public void buildItem(ItemStack itemstack, EntityPlayer player) {
        if (!this.canBuildItem()) {
            return;
        }
        if (itemstack.func_77973_b() instanceof ItemAgebook) {
            ItemAgebook.create(itemstack, player, this.pages, this.pendingtitle);
            this.pages.clear();
            this.pendingtitle = null;
            --this.itemstacks[1].field_77994_a;
            if (this.itemstacks[1].field_77994_a <= 0) {
                this.itemstacks[1] = null;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        } else {
            itemstack.field_77994_a = 0;
        }
    }

    private boolean canBuildItem() {
        if (this.itemstacks[1] == null) {
            return false;
        }
        if (!this.isValidCover(this.itemstacks[1])) {
            return false;
        }
        if (this.pages.size() == 0) {
            return false;
        }
        if (!Page.isLinkPanel(this.pages.get(0))) {
            return false;
        }
        if (this.pendingtitle == null || this.pendingtitle.equals("")) {
            return false;
        }
        for (int i = 1; i < this.pages.size(); ++i) {
            if (!Page.isLinkPanel(this.pages.get(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack getCraftedItem() {
        if (!this.canBuildItem()) {
            return null;
        }
        return new ItemStack((Item)ModItems.agebook);
    }

    public void setPages(List<ItemStack> page_list) {
        if (this.field_145850_b.field_72995_K) {
            this.pages = page_list;
        }
    }

    public List<ItemStack> getPageList() {
        return this.pages;
    }

    public ItemStack insertPage(ItemStack stack, int i) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() == Items.field_151121_aF) {
            while (stack.field_77994_a > 0) {
                ItemStack clone = stack.func_77946_l();
                clone.field_77994_a = 1;
                if ((clone = ItemPage.createItemstack(clone)) == null || this.insertPage(clone, i) != null) {
                    return stack;
                }
                --stack.field_77994_a;
            }
            if (stack.field_77994_a == 0) {
                stack = null;
            }
            return stack;
        }
        if (stack.func_77973_b() != ModItems.page) {
            return stack;
        }
        while (stack.field_77994_a > 0) {
            ItemStack clone = stack.func_77946_l();
            clone.field_77994_a = 1;
            this.pages.add(i, clone);
            --stack.field_77994_a;
        }
        stack = null;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        return stack;
    }

    public ItemStack insertFromFolder(ItemStack folder, int index) {
        if (folder.func_77973_b() != ModItems.folder) {
            return folder;
        }
        int size = InventoryFolder.getLargestSlotId(folder);
        if (size == -1) {
            for (ItemStack page : this.pages) {
                InventoryFolder.addItem(folder, page);
            }
            this.pages.clear();
        } else {
            for (int slot = 0; slot < size + 1; ++slot) {
                ItemStack page = InventoryFolder.getItem(folder, slot);
                if (page == null) continue;
                if ((page = this.insertPage(page, index)) == null) {
                    ++index;
                }
                InventoryFolder.setItem(folder, slot, page);
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        return null;
    }

    public ItemStack removePage(int i) {
        if (i >= this.pages.size()) {
            return null;
        }
        ItemStack itemstack = this.pages.remove(i);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        return itemstack;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.itemstacks[par1] != null) {
            ItemStack itemstack = this.itemstacks[par1];
            this.itemstacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public int[] func_94128_d(int par1) {
        return isidedslots;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int par3) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return false;
    }
}

