/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.network.packet;

import com.xcompwiz.mystcraft.explosion.ExplosionAdvanced;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffect;
import com.xcompwiz.mystcraft.network.packet.PacketBase;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkPosition;

public class MPacketExplosion
extends PacketBase {
    @Override
    public void handle(ByteBuf data, EntityPlayer player) {
        double posX = data.readDouble();
        double posY = data.readDouble();
        double posZ = data.readDouble();
        float size = data.readFloat();
        int x = (int)posX;
        int y = (int)posY;
        int z = (int)posZ;
        int count = data.readInt();
        ArrayList<ExplosionEffect> effects = new ArrayList<ExplosionEffect>();
        for (int i = 0; i < count; ++i) {
            ExplosionEffect effect = ExplosionAdvanced.getEffectById(data.readByte());
            if (effect == null) continue;
            effects.add(effect);
        }
        count = data.readInt();
        ArrayList<ChunkPosition> blocks = new ArrayList<ChunkPosition>();
        for (int i = 0; i < count; ++i) {
            blocks.add(new ChunkPosition(data.readByte() + x, data.readByte() + y, data.readByte() + z));
        }
        ExplosionAdvanced explosion = new ExplosionAdvanced(player.field_70170_p, null, posX, posY, posZ, size);
        explosion.blocks = blocks;
        explosion.effects = effects;
        explosion.doExplosionB(true);
    }

    public static FMLProxyPacket createPacket(EntityPlayer player, ExplosionAdvanced explosion) {
        ByteBuf data = PacketBase.createDataBuffer(new Object(){}.getClass().getEnclosingClass());
        data.writeDouble(explosion.explosionX);
        data.writeDouble(explosion.explosionY);
        data.writeDouble(explosion.explosionZ);
        data.writeFloat(explosion.explosionSize);
        data.writeInt(explosion.effects.size());
        for (ExplosionEffect effect : explosion.effects) {
            data.writeByte((int)ExplosionAdvanced.getEffectId(effect));
        }
        int x = (int)explosion.explosionX;
        int y = (int)explosion.explosionY;
        int z = (int)explosion.explosionZ;
        data.writeInt(explosion.blocks.size());
        for (ChunkPosition coords : explosion.blocks) {
            int var7 = coords.field_151329_a - x;
            int var8 = coords.field_151327_b - y;
            int var9 = coords.field_151328_c - z;
            data.writeByte(var7);
            data.writeByte(var8);
            data.writeByte(var9);
        }
        return MPacketExplosion.buildPacket(data);
    }
}

