/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import buildcraft.transport.TravelingItem;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.blocks.powertile.LogisticsPowerJunctionTileEntity;
import logisticspipes.interfaces.IBufferItems;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IItemAdvancedExistance;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.ISpecialInsertion;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.ITargetSlotInformation;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.ItemBufferSyncPacket;
import logisticspipes.network.packets.pipe.PipeContentPacket;
import logisticspipes.network.packets.pipe.PipeContentRequest;
import logisticspipes.network.packets.pipe.PipePositionPacket;
import logisticspipes.pipes.PipeItemsFluidSupplier;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.LPRoutedBCTravelingItem;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.transport.LPItemList;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.SyncList;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTransportLogistics {
    private final int _bufferTimeOut = 40;
    public final SyncList<Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer>> _itemBuffer = new SyncList();
    private Chunk chunk;
    public LPItemList items = new LPItemList(this);
    public LogisticsTileGenericPipe container;
    public final boolean isRouted;
    public final int MAX_DESTINATION_UNREACHABLE_BUFFER = 30;

    public PipeTransportLogistics(boolean isRouted) {
        this.isRouted = isRouted;
    }

    public void initialize() {
        if (MainProxy.isServer(this.getWorld())) {
            this.chunk = this.getWorld().func_72938_d(this.container.field_145851_c, this.container.field_145849_e);
            ItemBufferSyncPacket packet = PacketHandler.getPacket(ItemBufferSyncPacket.class);
            packet.setTilePos(this.container);
            this._itemBuffer.setPacketType(packet, MainProxy.getDimensionForWorld(this.getWorld()), this.container.field_145851_c, this.container.field_145849_e);
        }
    }

    public void markChunkModified(TileEntity tile) {
        if (tile != null && this.chunk != null && (this.container.field_145851_c >> 4 != tile.field_145851_c >> 4 || this.container.field_145849_e >> 4 != tile.field_145849_e >> 4)) {
            this.chunk.field_76643_l = true;
            if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe != null && ((LogisticsTileGenericPipe)tile).pipe.transport instanceof PipeTransportLogistics && ((LogisticsTileGenericPipe)tile).pipe.transport.chunk != null) {
                ((LogisticsTileGenericPipe)tile).pipe.transport.chunk.field_76643_l = true;
            } else {
                this.getWorld().func_72964_e((int)tile.field_145851_c, (int)tile.field_145849_e).field_76643_l = true;
            }
        }
    }

    protected CoreUnroutedPipe getPipe() {
        return this.container.pipe;
    }

    protected CoreRoutedPipe getRoutedPipe() {
        if (!this.isRouted) {
            throw new UnsupportedOperationException("Can't use a Transport pipe as a routing pipe");
        }
        return (CoreRoutedPipe)this.container.pipe;
    }

    public void updateEntity() {
        this.moveSolids();
        if (MainProxy.isServer(this.getWorld())) {
            if (!this._itemBuffer.isEmpty()) {
                LinkedList<LPTravelingItem.LPTravelingItemServer> toAdd = new LinkedList<LPTravelingItem.LPTravelingItemServer>();
                Iterator<Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer>> iterator = this._itemBuffer.iterator();
                while (iterator.hasNext()) {
                    Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer> next = iterator.next();
                    int n = (Integer)((Pair)next.getValue2()).getValue1();
                    if (n > 0) {
                        ((Pair)next.getValue2()).setValue1(n - 1);
                        continue;
                    }
                    if (next.getValue3() != null) {
                        if (this.getRoutedPipe().getRouter().hasRoute(next.getValue3().getDestination(), next.getValue3().getTransportMode() == IRoutedItem.TransportMode.Active, next.getValue3().getItemIdentifierStack().getItem()) || (Integer)((Pair)next.getValue2()).getValue2() > 30) {
                            next.getValue3().setBufferCounter((Integer)((Pair)next.getValue2()).getValue2() + 1);
                            toAdd.add(next.getValue3());
                            iterator.remove();
                            continue;
                        }
                        ((Pair)next.getValue2()).setValue2((Integer)((Pair)next.getValue2()).getValue2() + 1);
                        ((Pair)next.getValue2()).setValue1(40);
                        continue;
                    }
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem((ItemIdentifierStack)next.getValue1());
                    item.setDoNotBuffer(true);
                    item.setBufferCounter((Integer)((Pair)next.getValue2()).getValue2() + 1);
                    toAdd.add(item);
                    iterator.remove();
                }
                for (LPTravelingItem lPTravelingItem : toAdd) {
                    this.injectItem(lPTravelingItem, ForgeDirection.UP);
                }
            }
            this._itemBuffer.sendUpdateToWaters();
        }
    }

    public void dropBuffer() {
        Iterator<Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer>> iterator = this._itemBuffer.iterator();
        while (iterator.hasNext()) {
            ItemIdentifierStack next = (ItemIdentifierStack)iterator.next().getValue1();
            MainProxy.dropItems(this.getWorld(), next.makeNormalStack(), this.getPipe().getX(), this.getPipe().getY(), this.getPipe().getZ());
            iterator.remove();
        }
    }

    public int injectItem(LPTravelingItem.LPTravelingItemServer item, ForgeDirection inputOrientation) {
        return this.injectItem((LPTravelingItem)item, inputOrientation);
    }

    public int injectItem(LPTravelingItem item, ForgeDirection inputOrientation) {
        if (item.isCorrupted()) {
            return 0;
        }
        this.getPipe().triggerDebug();
        int originalCount = item.getItemIdentifierStack().getStackSize();
        item.input = inputOrientation;
        while (item.getPosition() >= 1.0f) {
            item.setPosition(item.getPosition() - 1.0f);
        }
        if (MainProxy.isServer(this.container.func_145831_w())) {
            this.readjustSpeed((LPTravelingItem.LPTravelingItemServer)item);
            item.output = this.resolveDestination((LPTravelingItem.LPTravelingItemServer)item);
            if (item.output == null) {
                return 0;
            }
            this.getPipe().debug.log("Injected Item: [" + item.input + ", " + item.output + "] (" + ((LPTravelingItem.LPTravelingItemServer)item).getInfo());
        } else {
            item.output = ForgeDirection.UNKNOWN;
        }
        this.items.add(item);
        if (MainProxy.isServer(this.container.func_145831_w()) && !this.getPipe().isOpaque()) {
            this.sendItemPacket((LPTravelingItem.LPTravelingItemServer)item);
        }
        return originalCount - item.getItemIdentifierStack().getStackSize();
    }

    public int injectItem(IRoutedItem item, ForgeDirection inputOrientation) {
        return this.injectItem((LPTravelingItem)SimpleServiceLocator.routedItemHelper.getServerTravelingItem(item), inputOrientation);
    }

    protected void reverseItem(LPTravelingItem.LPTravelingItemServer item) {
        if (item.isCorrupted()) {
            return;
        }
        if (this.getPipe() instanceof IBufferItems) {
            item.getItemIdentifierStack().setStackSize(((IBufferItems)((Object)this.getPipe())).addToBuffer(item.getItemIdentifierStack(), item.getAdditionalTargetInformation()));
            if (item.getItemIdentifierStack().getStackSize() <= 0) {
                return;
            }
        }
        item.id = item.getNextId();
        if (item.getPosition() >= 1.0f) {
            item.setPosition(item.getPosition() - 1.0f);
        }
        item.input = item.output.getOpposite();
        this.readjustSpeed(item);
        item.output = this.resolveDestination(item);
        if (item.output == null) {
            return;
        }
        if (item.output == ForgeDirection.UNKNOWN) {
            this.dropItem(item);
            return;
        }
        this.items.unscheduleRemoval(item);
        if (!this.getPipe().isOpaque()) {
            this.sendItemPacket(item);
        }
    }

    public ForgeDirection resolveDestination(LPTravelingItem.LPTravelingItemServer data) {
        if (this.isRouted) {
            return this.resolveRoutedDestination(data);
        }
        return this.resolveUnroutedDestination(data);
    }

    public ForgeDirection resolveUnroutedDestination(LPTravelingItem.LPTravelingItemServer data) {
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>(Arrays.asList(ForgeDirection.VALID_DIRECTIONS));
        dirs.remove(data.input.getOpposite());
        Iterator iter = dirs.iterator();
        while (iter.hasNext()) {
            ForgeDirection dir = (ForgeDirection)iter.next();
            LPPosition pos = this.getPipe().getLPPosition();
            pos.moveForward(dir);
            TileEntity tile = pos.getTileEntity(this.getWorld());
            if (!SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
                iter.remove();
                continue;
            }
            if (this.container.isPipeConnected(dir)) continue;
            iter.remove();
        }
        if (dirs.isEmpty()) {
            return ForgeDirection.UNKNOWN;
        }
        int num = new Random().nextInt(dirs.size());
        return (ForgeDirection)dirs.get(num);
    }

    public ForgeDirection resolveRoutedDestination(LPTravelingItem.LPTravelingItemServer data) {
        ForgeDirection value;
        ForgeDirection blocked = null;
        if (data.getDestinationUUID() == null) {
            ItemIdentifierStack stack = data.getItemIdentifierStack();
            ItemRoutingInformation result = this.getRoutedPipe().getQueuedForItemStack(stack);
            if (result != null) {
                data.setInformation(result);
                data.getInfo().setItem(stack);
                blocked = data.input.getOpposite();
            }
        }
        if (data.getItemIdentifierStack() != null) {
            this.getRoutedPipe().relayedItem(data.getItemIdentifierStack().getStackSize());
        }
        if (data.getDestination() >= 0 && !this.getRoutedPipe().getRouter().hasRoute(data.getDestination(), data.getTransportMode() == IRoutedItem.TransportMode.Active, data.getItemIdentifierStack().getItem()) && data.getBufferCounter() < 30) {
            this._itemBuffer.add(new Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer>(data.getItemIdentifierStack(), new Pair<Integer, Integer>(40, data.getBufferCounter()), data));
            return null;
        }
        if (this.getRoutedPipe().stillNeedReplace() || this.getRoutedPipe().initialInit()) {
            data.setDoNotBuffer(false);
            value = ForgeDirection.UNKNOWN;
        } else {
            value = this.getRoutedPipe().getRouteLayer().getOrientationForItem(data, blocked);
        }
        if (value == null && MainProxy.isClient(this.getWorld())) {
            return null;
        }
        if (value == null) {
            LogisticsPipes.log.fatal("THIS IS NOT SUPPOSED TO HAPPEN!");
            return ForgeDirection.UNKNOWN;
        }
        if (value == ForgeDirection.UNKNOWN && !data.getDoNotBuffer() && data.getBufferCounter() < 5) {
            this._itemBuffer.add(new Triplet<ItemIdentifierStack, Pair<Integer, Integer>, Object>(data.getItemIdentifierStack(), new Pair<Integer, Integer>(40, data.getBufferCounter()), null));
            return null;
        }
        if (value != ForgeDirection.UNKNOWN && !this.getRoutedPipe().getRouter().isRoutedExit(value) && !this.isItemExitable(data.getItemIdentifierStack())) {
            return null;
        }
        data.resetDelay();
        return value;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("travelingEntities", 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            try {
                NBTTagCompound dataTag = nbttaglist.func_150305_b(j);
                LPTravelingItem.LPTravelingItemServer item = new LPTravelingItem.LPTravelingItemServer(dataTag);
                if (item.isCorrupted()) continue;
                this.items.scheduleLoad(item);
                continue;
            }
            catch (Throwable dataTag) {
                // empty catch block
            }
        }
        this._itemBuffer.clear();
        NBTTagList nbttaglist2 = nbt.func_150295_c("buffercontents", 10);
        for (int i = 0; i < nbttaglist2.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist2.func_150305_b(i);
            this._itemBuffer.add(new Triplet<ItemIdentifierStack, Pair<Integer, Integer>, Object>(ItemIdentifierStack.getFromStack(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1)), new Pair<Integer, Integer>(40, 0), null));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (LPTravelingItem lPTravelingItem : this.items) {
            if (!(lPTravelingItem instanceof LPTravelingItem.LPTravelingItemServer)) continue;
            NBTTagCompound dataTag = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)dataTag);
            ((LPTravelingItem.LPTravelingItemServer)lPTravelingItem).writeToNBT(dataTag);
        }
        nbt.func_74782_a("travelingEntities", (NBTBase)nbttaglist);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (Pair pair : this._itemBuffer) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            ((ItemIdentifierStack)pair.getValue1()).makeNormalStack().func_77955_b(nbttagcompound1);
            nbttaglist2.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("buffercontents", (NBTBase)nbttaglist2);
    }

    public void readjustSpeed(LPTravelingItem.LPTravelingItemServer item) {
        float defaultBoost = 1.0f;
        switch (item.getTransportMode()) {
            case Default: {
                defaultBoost = 20.0f;
                break;
            }
            case Passive: {
                defaultBoost = 25.0f;
                break;
            }
            case Active: {
                defaultBoost = 30.0f;
                break;
            }
            case Unknown: {
                defaultBoost = 20.0f;
                break;
            }
            default: {
                defaultBoost = 20.0f;
            }
        }
        if (this.isRouted) {
            float multiplyerSpeed = 1.0f + 0.02f * (float)this.getRoutedPipe().getUpgradeManager().getSpeedUpgradeCount();
            float multiplyerPower = 1.0f + 0.03f * (float)this.getRoutedPipe().getUpgradeManager().getSpeedUpgradeCount();
            float add = Math.max(item.getSpeed(), 0.01f * defaultBoost * multiplyerPower) - item.getSpeed();
            if (this.getRoutedPipe().useEnergy((int)((double)(add * 50.0f) + 0.5))) {
                item.setSpeed(Math.min(Math.max(item.getSpeed(), 0.01f * defaultBoost * multiplyerSpeed), 1.0f));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleTileReachedServer(LPTravelingItem.LPTravelingItemServer arrivingItem, TileEntity tile, ForgeDirection dir) {
        block30: {
            block32: {
                int len$;
                ForgeDirection[] arr$;
                boolean tookSome;
                block33: {
                    block29: {
                        ForgeDirection[] dirs;
                        block31: {
                            ItemRoutingInformation info;
                            LPTravelingItem.LPTravelingItemServer routed;
                            boolean isSpecialConnectionInformationTransition;
                            block28: {
                                if (this.isRouted && this.getPipe().container.tilePart.getBCPipePluggable(dir) != null && this.getPipe().container.tilePart.getBCPipePluggable(dir).isAcceptingItems(arrivingItem)) {
                                    LPTravelingItem.LPTravelingItemServer remainingItem = this.getPipe().container.tilePart.getBCPipePluggable(dir).handleItem(arrivingItem);
                                    if (remainingItem != null) {
                                        this.getRoutedPipe().getRouter().update(true, this.getRoutedPipe());
                                        this.injectItem(remainingItem, dir);
                                    }
                                    return;
                                }
                                if (this.getPipe() instanceof PipeItemsFluidSupplier) {
                                    ((PipeItemsFluidSupplier)this.getPipe()).endReached(arrivingItem, tile);
                                    if (arrivingItem.getItemIdentifierStack().getStackSize() <= 0) {
                                        return;
                                    }
                                }
                                this.markChunkModified(tile);
                                if (MainProxy.isServer(this.getWorld()) && arrivingItem.getInfo() != null && arrivingItem.getArrived() && this.isRouted) {
                                    this.getRoutedPipe().notifyOfItemArival(arrivingItem.getInfo());
                                }
                                if (this.getPipe() instanceof FluidRoutedPipe && ((FluidRoutedPipe)this.getPipe()).endReached(arrivingItem, tile)) {
                                    return;
                                }
                                isSpecialConnectionInformationTransition = false;
                                if (MainProxy.isServer(this.getWorld()) && SimpleServiceLocator.specialtileconnection.needsInformationTransition(tile)) {
                                    isSpecialConnectionInformationTransition = true;
                                    SimpleServiceLocator.specialtileconnection.transmit(tile, arrivingItem);
                                }
                                if (!SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) break block28;
                                if (this.passToNextPipe(arrivingItem, tile)) {
                                    return;
                                }
                                break block29;
                            }
                            if (!(tile instanceof IInventory) || !this.isRouted) break block29;
                            this.getRoutedPipe().getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
                            if (!MainProxy.isServer(this.getWorld())) break block30;
                            if (!isSpecialConnectionInformationTransition && !this.isItemExitable(arrivingItem.getItemIdentifierStack())) {
                                return;
                            }
                            if (arrivingItem instanceof IRoutedItem && (routed = arrivingItem).getTransportMode() != IRoutedItem.TransportMode.Active && !this.getRoutedPipe().getTransportLayer().stillWantItem(routed)) {
                                this.reverseItem(arrivingItem);
                                return;
                            }
                            LogisticsModule.ModulePositionType slot = null;
                            int positionInt = -1;
                            if (arrivingItem.getInfo().targetInfo instanceof PipeLogisticsChassi.ChassiTargetInformation) {
                                positionInt = ((PipeLogisticsChassi.ChassiTargetInformation)arrivingItem.getInfo().targetInfo).getModuleSlot();
                                slot = LogisticsModule.ModulePositionType.SLOT;
                            } else if (LPConstants.DEBUG && this.container.pipe instanceof PipeLogisticsChassi) {
                                System.out.println(arrivingItem);
                                new RuntimeException("[ItemInsertion] Information weren't ment for a chassi pipe").printStackTrace();
                            }
                            ISlotUpgradeManager slotManager = this.getRoutedPipe().getUpgradeManager(slot, positionInt);
                            tookSome = false;
                            if (arrivingItem.getAdditionalTargetInformation() instanceof ITargetSlotInformation) {
                                IInventoryUtil util;
                                ITargetSlotInformation information = (ITargetSlotInformation)((Object)arrivingItem.getAdditionalTargetInformation());
                                IInventory inv = (IInventory)tile;
                                if (inv instanceof ISidedInventory) {
                                    inv = new SidedInventoryMinecraftAdapter((ISidedInventory)inv, ForgeDirection.UNKNOWN, false);
                                }
                                if ((util = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv)) instanceof ISpecialInsertion) {
                                    int slot2 = information.getTargetSlot();
                                    int amount = information.getAmount();
                                    if (util.getSizeInventory() > slot2) {
                                        ItemStack content = util.getStackInSlot(slot2);
                                        ItemStack toAdd = arrivingItem.getItemIdentifierStack().makeNormalStack();
                                        toAdd.field_77994_a = Math.min(toAdd.field_77994_a, Math.max(0, amount - (content != null ? content.field_77994_a : 0)));
                                        if (toAdd.field_77994_a > 0 && util.getSizeInventory() > slot2) {
                                            int added = ((ISpecialInsertion)((Object)util)).addToSlot(toAdd, slot2);
                                            arrivingItem.getItemIdentifierStack().lowerStackSize(added);
                                            if (added > 0) {
                                                tookSome = true;
                                            }
                                        }
                                    }
                                    if (information.isLimited()) {
                                        if (arrivingItem.getItemIdentifierStack().getStackSize() > 0) {
                                            this.reverseItem(arrivingItem);
                                        }
                                        return;
                                    }
                                }
                            }
                            if (this.getRoutedPipe().getUpgradeManager().hasCombinedSneakyUpgrade() && !slotManager.hasOwnSneakyUpgrade()) break block31;
                            ForgeDirection insertion = arrivingItem.output.getOpposite();
                            if (slotManager.hasSneakyUpgrade()) {
                                insertion = slotManager.getSneakyOrientation();
                            }
                            ItemStack added = InventoryHelper.getTransactorFor(tile, dir.getOpposite()).add(arrivingItem.getItemIdentifierStack().makeNormalStack(), insertion, true);
                            arrivingItem.getItemIdentifierStack().lowerStackSize(added.field_77994_a);
                            if (added.field_77994_a > 0 && arrivingItem instanceof IRoutedItem) {
                                tookSome = true;
                                arrivingItem.setBufferCounter(0);
                            }
                            if (arrivingItem.getItemIdentifierStack().getStackSize() <= 0) {
                                info = arrivingItem.getInfo();
                                info.getItem().setStackSize(added.field_77994_a);
                                this.insertedItemStack(info, tile);
                                return;
                            }
                            info = arrivingItem.getInfo().clone();
                            info.getItem().setStackSize(added.field_77994_a);
                            this.insertedItemStack(info, tile);
                            break block32;
                        }
                        arr$ = dirs = this.getRoutedPipe().getUpgradeManager().getCombinedSneakyOrientation();
                        len$ = arr$.length;
                        break block33;
                    }
                    this.dropItem(arrivingItem);
                    return;
                }
                for (int i$ = 0; i$ < len$; ++i$) {
                    ItemRoutingInformation info;
                    ForgeDirection insertion = arr$[i$];
                    if (insertion == null) continue;
                    ItemStack added = InventoryHelper.getTransactorFor(tile, dir.getOpposite()).add(arrivingItem.getItemIdentifierStack().makeNormalStack(), insertion, true);
                    arrivingItem.getItemIdentifierStack().lowerStackSize(added.field_77994_a);
                    if (added.field_77994_a > 0 && arrivingItem instanceof IRoutedItem) {
                        tookSome = true;
                        arrivingItem.setBufferCounter(0);
                    }
                    if (arrivingItem.getItemIdentifierStack().getStackSize() <= 0) {
                        info = arrivingItem.getInfo();
                        info.getItem().setStackSize(added.field_77994_a);
                        this.insertedItemStack(info, tile);
                        return;
                    }
                    info = arrivingItem.getInfo().clone();
                    info.getItem().setStackSize(added.field_77994_a);
                    this.insertedItemStack(info, tile);
                }
            }
            if (arrivingItem.getItemIdentifierStack().getStackSize() > 0) {
                this.reverseItem(arrivingItem);
            }
        }
    }

    protected void handleTileReachedClient(LPTravelingItem.LPTravelingItemClient arrivingItem, TileEntity tile) {
        if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
            this.passToNextPipe(arrivingItem, tile);
        }
    }

    protected boolean isItemExitable(ItemIdentifierStack itemIdentifierStack) {
        if (itemIdentifierStack != null && itemIdentifierStack.makeNormalStack().func_77973_b() instanceof IItemAdvancedExistance) {
            return ((IItemAdvancedExistance)itemIdentifierStack.makeNormalStack().func_77973_b()).canExistInNormalInventory(itemIdentifierStack.makeNormalStack());
        }
        return true;
    }

    protected void insertedItemStack(ItemRoutingInformation info, TileEntity tile) {
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        if (this.isRouted) {
            ForgeDirection ori;
            if ((tile instanceof ILogisticsPowerProvider || tile instanceof ISubSystemPowerProvider) && (ori = OrientationsUtil.getOrientationOfTilewithTile(this.container, tile)) != null && ori != ForgeDirection.UNKNOWN) {
                return !(tile instanceof LogisticsPowerJunctionTileEntity) && !(tile instanceof ISubSystemPowerProvider) || OrientationsUtil.isSide(ori);
            }
            if (SimpleServiceLocator.betterStorageProxy.isBetterStorageCrate(tile) || SimpleServiceLocator.factorizationProxy.isBarral(tile) || this.getPipe().getUpgradeManager().hasRFPowerSupplierUpgrade() && SimpleServiceLocator.cofhPowerProxy.isEnergyReceiver(tile) || this.getPipe().getUpgradeManager().getIC2PowerLevel() > 0 && SimpleServiceLocator.IC2Proxy.isEnergySink(tile)) {
                return true;
            }
            if (tile instanceof ISidedInventory) {
                int[] slots = ((ISidedInventory)tile).func_94128_d(side.getOpposite().ordinal());
                return slots != null && slots.length > 0;
            }
            return SimpleServiceLocator.pipeInformationManager.isItemPipe(tile) || this.getPipe().isFluidPipe() && SimpleServiceLocator.pipeInformationManager.isFluidPipe(tile) || tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0;
        }
        return SimpleServiceLocator.pipeInformationManager.isItemPipe(tile);
    }

    private void moveSolids() {
        this.items.flush();
        this.items.scheduleAdd();
        for (LPTravelingItem item : this.items) {
            if (item.lastTicked >= MainProxy.getGlobalTick()) continue;
            item.lastTicked = MainProxy.getGlobalTick();
            item.addAge();
            item.setPosition(item.getPosition() + item.getSpeed());
            if (!this.endReached(item)) continue;
            if (item.output == ForgeDirection.UNKNOWN) {
                if (MainProxy.isServer(this.container.func_145831_w())) {
                    this.dropItem((LPTravelingItem.LPTravelingItemServer)item);
                }
                this.items.scheduleRemoval(item);
                continue;
            }
            TileEntity tile = this.container.getTile(item.output);
            if (!this.items.scheduleRemoval(item)) continue;
            if (MainProxy.isServer(this.container.func_145831_w())) {
                this.handleTileReachedServer((LPTravelingItem.LPTravelingItemServer)item, tile, item.output);
                continue;
            }
            this.handleTileReachedClient((LPTravelingItem.LPTravelingItemClient)item, tile);
        }
        this.items.removeScheduledItems();
        this.items.addScheduledItems();
    }

    private boolean passToNextPipe(LPTravelingItem item, TileEntity tile) {
        IPipeInformationProvider information = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile);
        if (information != null) {
            return information.acceptItem(item, this.container);
        }
        return false;
    }

    @ModDependentMethod(modId="BuildCraft|Transport")
    public void injectItem(TravelingItem item, ForgeDirection inputOrientation) {
        if (MainProxy.isServer(this.getWorld())) {
            if (item instanceof LPRoutedBCTravelingItem) {
                ItemRoutingInformation info = ((LPRoutedBCTravelingItem)item).getRoutingInformation();
                info.setItem(ItemIdentifierStack.getFromStack(item.getItemStack()));
                LPTravelingItem.LPTravelingItemServer lpItem = new LPTravelingItem.LPTravelingItemServer(info);
                lpItem.setSpeed(item.getSpeed());
                this.injectItem(lpItem, inputOrientation);
            } else {
                ItemRoutingInformation info = LPRoutedBCTravelingItem.restoreFromExtraNBTData(item);
                if (info != null) {
                    info.setItem(ItemIdentifierStack.getFromStack(item.getItemStack()));
                    LPTravelingItem.LPTravelingItemServer lpItem = new LPTravelingItem.LPTravelingItemServer(info);
                    lpItem.setSpeed(item.getSpeed());
                    this.injectItem(lpItem, inputOrientation);
                } else {
                    LPTravelingItem.LPTravelingItemServer lpItem = SimpleServiceLocator.routedItemHelper.createNewTravelItem(item.getItemStack());
                    lpItem.setSpeed(item.getSpeed());
                    this.injectItem(lpItem, inputOrientation);
                }
            }
        }
    }

    private void dropItem(LPTravelingItem.LPTravelingItemServer item) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        item.setSpeed(0.05f);
        item.setContainer(this.container);
        EntityItem entity = item.toEntityItem();
        if (entity != null) {
            this.container.func_145831_w().func_72838_d((Entity)entity);
        }
    }

    protected boolean endReached(LPTravelingItem item) {
        return item.getPosition() >= (item.output == ForgeDirection.UNKNOWN ? 0.75f : 1.0f);
    }

    protected void neighborChange() {
    }

    public List<ItemStack> dropContents() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (MainProxy.isServer(this.getWorld())) {
            for (LPTravelingItem item : this.items) {
                list.add(item.getItemIdentifierStack().makeNormalStack());
            }
        }
        return list;
    }

    public boolean delveIntoUnloadedChunks() {
        return true;
    }

    private void sendItemPacket(LPTravelingItem.LPTravelingItemServer item) {
        if (MainProxy.isAnyoneWatching(this.container.field_145851_c, this.container.field_145849_e, MainProxy.getDimensionForWorld(this.getWorld()))) {
            if (!LPTravelingItem.clientSideKnownIDs.get(item.getId())) {
                MainProxy.sendPacketToAllWatchingChunk(this.container.field_145851_c, this.container.field_145849_e, MainProxy.getDimensionForWorld(this.getWorld()), PacketHandler.getPacket(PipeContentPacket.class).setItem(item.getItemIdentifierStack()).setTravelId(item.getId()));
                LPTravelingItem.clientSideKnownIDs.set(item.getId());
            }
            MainProxy.sendPacketToAllWatchingChunk(this.container.field_145851_c, this.container.field_145849_e, MainProxy.getDimensionForWorld(this.getWorld()), PacketHandler.getPacket(PipePositionPacket.class).setSpeed(item.getSpeed()).setPosition(item.getPosition()).setInput(item.input).setOutput(item.output).setTravelId(item.getId()).setTilePos(this.container));
        }
    }

    public void handleItemPositionPacket(int travelId, ForgeDirection input, ForgeDirection output, float speed, float position) {
        WeakReference<LPTravelingItem.LPTravelingItemClient> ref = LPTravelingItem.clientList.get(travelId);
        LPTravelingItem.LPTravelingItemClient item = null;
        if (ref != null) {
            item = (LPTravelingItem.LPTravelingItemClient)ref.get();
        }
        if (item == null) {
            this.sendItemContentRequest(travelId);
            item = new LPTravelingItem.LPTravelingItemClient(travelId, position, input, output);
            item.setSpeed(speed);
            LPTravelingItem.clientList.put(travelId, new WeakReference<LPTravelingItem.LPTravelingItemClient>(item));
        } else {
            if (item.getContainer() instanceof LogisticsTileGenericPipe) {
                ((LogisticsTileGenericPipe)item.getContainer()).pipe.transport.items.scheduleRemoval(item);
                ((LogisticsTileGenericPipe)item.getContainer()).pipe.transport.items.removeScheduledItems();
            }
            item.updateInformation(input, output, speed, position);
        }
        item.lastTicked = MainProxy.getGlobalTick();
        if (this.items.get(travelId) == null) {
            this.items.add(item);
        }
    }

    private void sendItemContentRequest(int travelId) {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(PipeContentRequest.class).setInteger(travelId));
    }

    public void sendItem(ItemStack stackToSend) {
        this.injectItem((LPTravelingItem)SimpleServiceLocator.routedItemHelper.createNewTravelItem(stackToSend), ForgeDirection.UP);
    }

    public World getWorld() {
        return this.container.func_145831_w();
    }

    public void onNeighborBlockChange(int blockId) {
    }

    public void onBlockPlaced() {
    }

    public void setTile(LogisticsTileGenericPipe tile) {
        this.container = tile;
    }
}

