/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.extratrees.genetics.ButterflySpecies;
import binnie.extratrees.genetics.ExtraTreeFruitGene;
import binnie.extratrees.genetics.ExtraTreeMutation;
import binnie.extratrees.genetics.ExtraTreeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ModuleGenetics
implements IInitializable {
    String[] branches = new String[]{"Malus Maleae Amygdaloideae Rosaceae", "Musa   Musaceae Zingiberales Commelinids Angiosperms", "Sorbus Maleae", "Tsuga   Pinaceae", "Fraxinus Oleeae  Oleaceae Lamiales Asterids Angiospems"};
    List<List<String>> classifications = new ArrayList<List<String>>();

    @Override
    public void preInit() {
        for (ExtraTreeFruitGene extraTreeFruitGene : ExtraTreeFruitGene.values()) {
            AlleleManager.alleleRegistry.registerAllele((IAllele)extraTreeFruitGene);
        }
        for (Enum enum_ : ExtraTreeSpecies.values()) {
            AlleleManager.alleleRegistry.registerAllele((IAllele)enum_);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        ExtraTreeSpecies.init();
        ExtraTreeFruitGene.init();
        for (ExtraTreeSpecies extraTreeSpecies : ExtraTreeSpecies.values()) {
            Binnie.Genetics.getTreeRoot().registerTemplate(extraTreeSpecies.getTemplate());
        }
        ExtraTreeMutation.init();
        if (BinnieCore.isLepidopteryActive()) {
            for (Enum enum_ : ButterflySpecies.values()) {
                AlleleManager.alleleRegistry.registerAllele((IAllele)enum_);
                Binnie.Genetics.getButterflyRoot().registerTemplate(((ButterflySpecies)enum_).getTemplate());
                String scientific = ((ButterflySpecies)enum_).branchName.substring(0, 1).toUpperCase() + ((ButterflySpecies)enum_).branchName.substring(1).toLowerCase();
                String uid = "trees." + ((ButterflySpecies)enum_).branchName.toLowerCase();
                IClassification branch = AlleleManager.alleleRegistry.getClassification("genus." + uid);
                if (branch == null) {
                    branch = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.GENUS, uid, scientific);
                }
                ((ButterflySpecies)enum_).branch = branch;
                ((ButterflySpecies)enum_).branch.addMemberSpecies((IAlleleSpecies)enum_);
            }
        }
    }

    private void generateBranches() {
        for (String string : this.branches) {
            ArrayList<String> set = new ArrayList<String>();
            for (String string2 : string.split(" ", 0)) {
                set.add(string2.toLowerCase());
            }
            this.classifications.add(set);
        }
        for (ExtraTreeSpecies extraTreeSpecies : ExtraTreeSpecies.values()) {
            IClassification branch = this.getOrCreateClassification(IClassification.EnumClassLevel.GENUS, extraTreeSpecies.branchName);
            branch.addMemberSpecies((IAlleleSpecies)extraTreeSpecies);
            extraTreeSpecies.branch = branch;
            IClassification clss = branch;
            int currentLevel = IClassification.EnumClassLevel.GENUS.ordinal();
            block5: while (clss.getParent() == null) {
                for (List<String> set : this.classifications) {
                    if (!set.contains(clss.getScientific().toLowerCase())) continue;
                    String nextLevel = "";
                    int index = set.indexOf(clss.getScientific().toLowerCase()) + 1;
                    while (nextLevel.length() == 0) {
                        try {
                            nextLevel = set.get(index++);
                        }
                        catch (IndexOutOfBoundsException ex) {
                            throw new RuntimeException("Reached end point at " + set.get(index - 2));
                        }
                        --currentLevel;
                    }
                    IClassification parent = this.getOrCreateClassification(IClassification.EnumClassLevel.values()[currentLevel], nextLevel);
                    parent.addMemberGroup(clss);
                    System.out.println("Went from " + clss.getScientific() + " to " + parent.getScientific());
                    clss = parent;
                    continue block5;
                }
            }
        }
    }

    private IClassification getOrCreateClassification(IClassification.EnumClassLevel level, String name) {
        String uid;
        if (level == IClassification.EnumClassLevel.GENUS) {
            name = "trees." + name;
        }
        if (AlleleManager.alleleRegistry.getClassification(uid = level.name().toLowerCase(Locale.ENGLISH) + "." + name.toLowerCase()) != null) {
            return AlleleManager.alleleRegistry.getClassification(uid);
        }
        return AlleleManager.alleleRegistry.createAndRegisterClassification(level, name.toLowerCase(), name);
    }
}

