/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IColourMix;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerColour;
import binnie.botany.api.IFlowerGenome;
import binnie.botany.api.IFlowerMutation;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.FlowerGenome;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Individual;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Flower
extends Individual
implements IFlower {
    public IFlowerGenome genome;
    public IFlowerGenome mate;
    int age = 0;
    boolean wilting = false;
    boolean flowered;

    public Flower(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Flower(IFlowerGenome genome, int age) {
        this.genome = genome;
        this.age = age;
        this.flowered = age > 0;
    }

    public String getDisplayName() {
        IAlleleFlowerSpecies species = this.getGenome().getPrimary();
        String name = "";
        if (species != null) {
            name = name + species.getName();
        }
        if (this.age == 0) {
            name = name + "";
        }
        return name;
    }

    public void addTooltip(List<String> list) {
        IAlleleFlowerSpecies primary = this.genome.getPrimary();
        IAlleleFlowerSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumFlowerChromosome.SPECIES)) {
            list.add("\u00a79" + primary.getName() + "-" + secondary.getName() + " Hybrid");
        }
        list.add("\u00a76Age: " + this.getAge());
        list.add("\u00a76T: " + this.getGenome().getPrimary().getTemperature() + " / " + this.getGenome().getToleranceTemperature());
        list.add("\u00a76M: " + (Object)((Object)this.getGenome().getPrimary().getMoisture()) + " / " + this.getGenome().getToleranceMoisture());
        list.add("\u00a76pH: " + this.getGenome().getPrimary().getHumidity() + " / " + this.getGenome().getTolerancePH());
        list.add("\u00a76Fert: " + this.getGenome().getFertility() + "x");
    }

    public String getIdent() {
        return this.getGenome().getPrimary().getUID();
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound == null) {
            this.genome = BotanyCore.getFlowerRoot().templateAsGenome(BotanyCore.getFlowerRoot().getDefaultTemplate());
            return;
        }
        this.age = nbttagcompound.func_74762_e("Age");
        this.wilting = nbttagcompound.func_74767_n("Wilt");
        this.flowered = nbttagcompound.func_74767_n("Flowered");
        if (nbttagcompound.func_74764_b("Genome")) {
            this.genome = new FlowerGenome(nbttagcompound.func_74775_l("Genome"));
        }
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = new FlowerGenome(nbttagcompound.func_74775_l("Mate"));
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound NBTmachine;
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Age", this.age);
        nbttagcompound.func_74757_a("Wilt", this.wilting);
        nbttagcompound.func_74757_a("Flowered", this.flowered);
        if (this.genome != null) {
            NBTmachine = new NBTTagCompound();
            this.genome.writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Genome", (NBTBase)NBTmachine);
        }
        if (this.mate != null) {
            NBTmachine = new NBTTagCompound();
            this.mate.writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Mate", (NBTBase)NBTmachine);
        }
    }

    public int getMetadata() {
        return 0;
    }

    @Override
    public IFlowerGenome getGenome() {
        return this.genome;
    }

    private IChromosome inheritChromosome(Random rand, IChromosome parent1, IChromosome parent2) {
        IAllele choice1 = rand.nextBoolean() ? parent1.getPrimaryAllele() : parent1.getSecondaryAllele();
        IAllele choice2 = rand.nextBoolean() ? parent2.getPrimaryAllele() : parent2.getSecondaryAllele();
        if (rand.nextBoolean()) {
            return new Chromosome(choice1, choice2);
        }
        return new Chromosome(choice2, choice1);
    }

    @Override
    public void mate(IFlower other) {
        this.mate = new FlowerGenome(other.getGenome().getChromosomes());
    }

    @Override
    public IFlowerGenome getMate() {
        return this.mate;
    }

    public IFlower copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Flower(nbttagcompound);
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void age() {
        if (this.age < 15) {
            ++this.age;
        }
    }

    @Override
    public void setAge(int i) {
        this.age = i;
    }

    @Override
    public int getMaxAge() {
        return this.getGenome().getLifespan();
    }

    @Override
    public boolean isWilted() {
        return this.wilting;
    }

    @Override
    public void setWilted(boolean wilted) {
        this.wilting = wilted;
    }

    @Override
    public boolean hasFlowered() {
        return this.flowered;
    }

    @Override
    public void setFlowered(boolean flowered) {
        this.flowered = flowered;
    }

    @Override
    public void removeMate() {
        this.mate = null;
    }

    @Override
    public IFlower getOffspring(World world) {
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        parent1 = this.mutateSpecies(world, this.genome, this.mate);
        parent2 = this.mutateSpecies(world, this.mate, this.genome);
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome((Random)world.field_73012_v, (IChromosome)parent1[i], (IChromosome)parent2[i]);
        }
        return new Flower(new FlowerGenome(chromosomes), 0);
    }

    private IChromosome[] mutateSpecies(World world, IFlowerGenome genomeOne, IFlowerGenome genomeTwo) {
        IFlowerGenome genome1;
        IFlowerGenome genome0;
        IAllele allele1;
        IAllele allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        IFlowerColour colour1 = genome0.getPrimaryColor();
        IFlowerColour colour2 = genome1.getPrimaryColor();
        if (colour1 != colour2) {
            for (IColourMix mutation : BotanyCore.getFlowerRoot().getColourMixes(true)) {
                if (!mutation.isMutation(colour1, colour2) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parent1[EnumFlowerChromosome.PRIMARY.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        if ((colour1 = genome0.getSecondaryColor()) != (colour2 = genome1.getSecondaryColor())) {
            for (IColourMix mutation : BotanyCore.getFlowerRoot().getColourMixes(true)) {
                if (!mutation.isMutation(colour1, colour2) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parent1[EnumFlowerChromosome.SECONDARY.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        if ((colour1 = genome0.getStemColor()) != (colour2 = genome1.getStemColor())) {
            for (IColourMix mutation : BotanyCore.getFlowerRoot().getColourMixes(true)) {
                if (!mutation.isMutation(colour1, colour2) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parent1[EnumFlowerChromosome.STEM.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        IChromosome[] template = null;
        for (IFlowerMutation mutation : BotanyCore.getFlowerRoot().getMutations(true)) {
            float chance = mutation.getChance(allele0, allele1, genome0, genome1);
            if (!(chance > 0.0f) || !(world.field_73012_v.nextFloat() * 100.0f < chance) || template != null) continue;
            template = BotanyCore.getFlowerRoot().templateAsChromosomes(mutation.getTemplate());
        }
        if (template != null) {
            parent1 = template;
        }
        return parent1;
    }
}

