/*
 * Decompiled with CFR 0.152.
 */
package neresources.compatibility.forestry;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.core.config.Config;
import neresources.api.distributions.DistributionBase;
import neresources.api.distributions.DistributionSquare;
import neresources.api.messages.ModifyOreMessage;
import neresources.api.messages.RegisterOreMessage;
import neresources.api.utils.Priority;
import neresources.compatibility.CompatBase;
import neresources.registry.MessageRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ForestryCompat
extends CompatBase {
    Block oreBlock;

    @Override
    protected void init() {
        this.registerOres();
    }

    private void registerOres() {
        ItemStack apatite = GameRegistry.findItemStack((String)"Forestry", (String)"apatite", (int)1);
        this.oreBlock = GameRegistry.findBlock((String)"Forestry", (String)"resources");
        MessageRegistry.addMessage(new ModifyOreMessage(new ItemStack(this.oreBlock, 1, 0), Priority.FIRST, apatite));
        if (Config.generateApatiteOre) {
            this.genApatite();
        }
        if (Config.generateCopperOre) {
            this.genCopper();
        }
        if (Config.generateTinOre) {
            this.genTin();
        }
    }

    private void genTin() {
        ItemStack ore = new ItemStack(this.oreBlock, 1, 2);
        int numVeins = 18;
        int minY = 16;
        int maxY = 92;
        int veinSize = 6;
        this.registerOre(new RegisterOreMessage(ore, (DistributionBase)new DistributionSquare(numVeins, veinSize, minY, maxY), new ItemStack[0]));
    }

    private void genCopper() {
        ItemStack ore = new ItemStack(this.oreBlock, 1, 1);
        int numVeins = 20;
        int minY = 32;
        int maxY = 108;
        int veinSize = 6;
        this.registerOre(new RegisterOreMessage(ore, (DistributionBase)new DistributionSquare(numVeins, veinSize, minY, maxY), new ItemStack[0]));
    }

    private void genApatite() {
        ItemStack ore = new ItemStack(this.oreBlock, 1, 0);
        float numVeins = 0.8f;
        int minY = 56;
        int maxY = 240;
        int veinSize = 36;
        float chance = numVeins * (float)veinSize / (float)((maxY - minY + 1) * 256);
        this.registerOre(new RegisterOreMessage(ore, (DistributionBase)new DistributionSquare(Math.max(0, minY - veinSize / 2), minY, maxY, Math.min(maxY + veinSize / 2, 255), chance), new ItemStack[0]));
    }
}

