/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft.client;

import com.mia.craftstudio.libgdx.Vector3;
import com.mia.craftstudio.minecraft.CraftStudioRendererVBO;
import com.mia.craftstudio.minecraft.INodeProvider;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVBO;
import com.mia.craftstudio.minecraft.forge.CSLibMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.lwjgl.opengl.GL11;

public class CSClientModelWrapperVariableVBO
extends CSClientModelWrapperVBO {
    private Set<CraftStudioRendererVBO> staticNodes1st;
    private Set<CraftStudioRendererVBO> staticNodes2nd;
    private List<Pattern> staticFilters = new ArrayList<Pattern>();
    private List<Pattern> defaultFilters = new ArrayList<Pattern>();
    private Map<String, CSClientModelWrapperVBO.RenderingObject> roMain = new HashMap<String, CSClientModelWrapperVBO.RenderingObject>();
    Set<CraftStudioRendererVBO> renderers1st = new HashSet<CraftStudioRendererVBO>();
    Set<CraftStudioRendererVBO> renderers2nd = new HashSet<CraftStudioRendererVBO>();

    public CSClientModelWrapperVariableVBO(ModelMetadata metadata) {
        super(metadata);
        String pattern;
        List<String> staticMesh = Arrays.asList(metadata.tileParams.get("Nodes_STATIC").split(";"));
        List<String> defaultNodes = Arrays.asList(metadata.tileParams.get("Nodes_DEFAULT").split(";"));
        for (String s : staticMesh) {
            pattern = s.replace(".", "\\.").replace("*", "*.").replace("?", ".");
            this.staticFilters.add(Pattern.compile(pattern));
        }
        for (String s : defaultNodes) {
            pattern = s.replace(".", "\\.").replace("*", "*.").replace("?", ".");
            this.defaultFilters.add(Pattern.compile(pattern));
        }
    }

    private Set<CraftStudioRendererVBO> computeNodesSet(Set<CraftStudioRendererVBO> nodes, List<Pattern> filter) {
        HashSet<CraftStudioRendererVBO> outSet = new HashSet<CraftStudioRendererVBO>();
        for (CraftStudioRendererVBO node : nodes) {
            for (Pattern p : filter) {
                if (!p.matcher(node.getNode().getFullName()).find()) continue;
                outSet.add(node);
            }
        }
        return outSet;
    }

    @Override
    protected void precompute() {
        for (CraftStudioRendererVBO renderer : this.topRenderers) {
            renderer.collectRenderers(this.renderers1st, this.renderers2nd);
        }
        this.staticNodes1st = this.computeNodesSet(this.renderers1st, this.staticFilters);
        this.staticNodes2nd = this.computeNodesSet(this.renderers2nd, this.staticFilters);
        Set<CraftStudioRendererVBO> defaultNodes1st = this.computeNodesSet(this.renderers1st, this.defaultFilters);
        Set<CraftStudioRendererVBO> defaultNodes2nd = this.computeNodesSet(this.renderers2nd, this.defaultFilters);
        defaultNodes1st.addAll(this.staticNodes1st);
        defaultNodes1st.addAll(this.staticNodes2nd);
        this.roDefault = new CSClientModelWrapperVBO.RenderingObject(this, this.generateVBOs(defaultNodes1st, defaultNodes2nd), new int[]{defaultNodes1st.size(), defaultNodes2nd.size()});
        this.isPrecomputed = true;
    }

    @Override
    public void render(Object instanceRenderState, float timeSinceLastRender, int pass, boolean renderOutline, float rotationAngle, Vector3 rotationVector, Vector3 preRotataionTranslation, Vector3 postRotataionTranslation) {
        if (!this.isPrecomputed) {
            this.precompute();
        }
        GL11.glPushMatrix();
        if (!Vector3.Zero.equals(preRotataionTranslation)) {
            GL11.glTranslatef((float)preRotataionTranslation.x, (float)preRotataionTranslation.y, (float)preRotataionTranslation.z);
        }
        if (!Vector3.Zero.equals(rotationVector)) {
            GL11.glRotatef((float)rotationAngle, (float)rotationVector.x, (float)rotationVector.y, (float)rotationVector.z);
        }
        if (!Vector3.Zero.equals(postRotataionTranslation)) {
            GL11.glTranslatef((float)postRotataionTranslation.x, (float)postRotataionTranslation.y, (float)postRotataionTranslation.z);
        }
        if (instanceRenderState instanceof INodeProvider) {
            INodeProvider tile = (INodeProvider)instanceRenderState;
            String hash = tile.getStatusHash();
            if (hash == null) {
                return;
            }
            if (!this.roMain.containsKey(hash)) {
                Set<CraftStudioRendererVBO> nodes1st = tile.getNodes(this.renderers1st);
                Set<CraftStudioRendererVBO> nodes2nd = tile.getNodes(this.renderers2nd);
                nodes1st.addAll(this.staticNodes1st);
                nodes2nd.addAll(this.staticNodes2nd);
                this.roMain.put(hash, new CSClientModelWrapperVBO.RenderingObject(this, this.generateVBOs(nodes1st, nodes2nd), new int[]{nodes1st.size(), nodes2nd.size()}));
            }
            this.renderWithVBO(this.roMain.get(hash), instanceRenderState, timeSinceLastRender, pass);
            if (renderOutline && CSLibMod.displayOutline) {
                this.renderOutline(this.roDefault, instanceRenderState, timeSinceLastRender);
            }
        } else {
            this.renderWithVBO(this.roDefault, instanceRenderState, timeSinceLastRender, pass);
        }
        GL11.glPopMatrix();
    }
}

