/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import ftb.lib.BlockDimPos;
import ftb.lib.EntityPos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class LMDimUtils {
    public static boolean teleportPlayer(Entity entity, EntityPos pos) {
        return pos != null && LMDimUtils.teleportPlayer(entity, pos.x, pos.y, pos.z, pos.dim);
    }

    public static boolean teleportPlayer(Entity entity, BlockDimPos pos) {
        return pos != null && LMDimUtils.teleportPlayer(entity, (double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, pos.dim);
    }

    public static boolean teleportPlayer(Entity entity, double x, double y, double z, int dim) {
        EntityPlayerMP player;
        if (entity == null) {
            return false;
        }
        entity.field_70143_R = 0.0f;
        EntityPlayerMP entityPlayerMP = player = entity instanceof EntityPlayer ? (EntityPlayerMP)entity : null;
        if (dim == entity.field_71093_bK) {
            if (x == entity.field_70165_t && y == entity.field_70163_u && z == entity.field_70161_v) {
                return true;
            }
            if (player != null) {
                player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
                return true;
            }
        }
        int from = entity.field_71093_bK;
        float rotationYaw = entity.field_70177_z;
        float rotationPitch = entity.field_70125_A;
        MinecraftServer server = MinecraftServer.func_71276_C();
        WorldServer fromDim = server.func_71218_a(from);
        WorldServer toDim = server.func_71218_a(dim);
        if (player != null) {
            server.func_71203_ab().transferPlayerToDimension(player, dim, (Teleporter)new TeleporterBlank(toDim));
            if (from == 1 && entity.func_70089_S()) {
                toDim.func_72838_d(entity);
                toDim.func_72866_a(entity, false);
            }
        } else {
            NBTTagCompound tagCompound = new NBTTagCompound();
            entity.func_70109_d(tagCompound);
            Class<?> entityClass = entity.getClass();
            fromDim.func_72900_e(entity);
            try {
                Entity newEntity = (Entity)entityClass.getConstructor(World.class).newInstance(toDim);
                newEntity.func_70020_e(tagCompound);
                newEntity.func_70012_b(x, y, z, rotationYaw, rotationPitch);
                newEntity.field_98038_p = true;
                toDim.func_72838_d(newEntity);
                newEntity.field_98038_p = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        entity.field_70143_R = 0.0f;
        entity.field_70177_z = rotationYaw;
        entity.field_70125_A = rotationPitch;
        if (player != null) {
            player.func_70634_a(x, y, z);
        } else {
            entity.func_70107_b(x, y, z);
        }
        return true;
    }

    public static World getWorld(int dim) {
        return DimensionManager.getWorld((int)dim);
    }

    public static String getDimName(int dim) {
        if (dim == 0) {
            return "Overworld";
        }
        if (dim == 1) {
            return "The End";
        }
        if (dim == -1) {
            return "Nether";
        }
        World w = LMDimUtils.getWorld(dim);
        return w == null ? "DIM" + dim : w.field_73011_w.func_80007_l();
    }

    public static double getMovementFactor(int dim) {
        if (dim == 0) {
            return 1.0;
        }
        if (dim == 1) {
            return 1.0;
        }
        if (dim == -1) {
            return 8.0;
        }
        World w = LMDimUtils.getWorld(dim);
        return w == null ? 1.0 : w.field_73011_w.getMovementFactor();
    }

    public static double getWorldScale(int dim) {
        return 1.0 / LMDimUtils.getMovementFactor(dim);
    }

    public static BlockDimPos getSpawnPoint(int dim) {
        World w = LMDimUtils.getWorld(dim);
        if (w == null) {
            return null;
        }
        ChunkCoordinates c = w.func_72861_E();
        if (c == null) {
            return null;
        }
        return new BlockDimPos(c, dim);
    }

    public static BlockDimPos getPlayerEntitySpawnPoint(EntityPlayerMP ep, int dim) {
        ChunkCoordinates c = ep.getBedLocation(dim);
        if (c == null) {
            return LMDimUtils.getSpawnPoint(dim);
        }
        return new BlockDimPos(c, dim);
    }

    private static class TeleporterBlank
    extends Teleporter {
        public TeleporterBlank(WorldServer w) {
            super(w);
        }

        public boolean func_85188_a(Entity e) {
            return true;
        }

        public boolean func_77184_b(Entity e, double x, double y, double z, float f) {
            return true;
        }

        public void func_77185_a(Entity entity, double x, double y, double z, float f) {
            entity.func_70012_b(x, y, z, entity.field_70125_A, entity.field_70177_z);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70143_R = 0.0f;
        }

        public void func_85189_a(long l) {
        }
    }
}

