/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import net.minecraftforge.common.util.ForgeDirection;

public enum HalfAxis {
    NEG_X(ForgeDirection.WEST),
    NEG_Y(ForgeDirection.DOWN),
    NEG_Z(ForgeDirection.NORTH),
    POS_X(ForgeDirection.EAST),
    POS_Y(ForgeDirection.UP),
    POS_Z(ForgeDirection.SOUTH);

    public final int x;
    public final int y;
    public final int z;
    public final ForgeDirection dir;
    public static final HalfAxis[] VALUES;
    private static final HalfAxis _ZERO;
    private static final HalfAxis[][] CROSS_PRODUCTS;
    private static final HalfAxis[] NEGATIONS;

    private HalfAxis(ForgeDirection dir) {
        this.x = dir.offsetX;
        this.y = dir.offsetY;
        this.z = dir.offsetZ;
        this.dir = dir;
    }

    public static HalfAxis cross(HalfAxis a, HalfAxis b) {
        return CROSS_PRODUCTS[a.ordinal()][b.ordinal()];
    }

    public HalfAxis cross(HalfAxis other) {
        return HalfAxis.cross(this, other);
    }

    public static HalfAxis negate(HalfAxis axis) {
        return NEGATIONS[axis.ordinal()];
    }

    public HalfAxis negate() {
        return HalfAxis.negate(this);
    }

    public static HalfAxis fromDirection(ForgeDirection dir) {
        switch (dir) {
            case EAST: {
                return POS_X;
            }
            case WEST: {
                return NEG_X;
            }
            case NORTH: {
                return NEG_Z;
            }
            case SOUTH: {
                return POS_Z;
            }
            case DOWN: {
                return NEG_Y;
            }
            case UP: {
                return POS_Y;
            }
        }
        throw new IllegalArgumentException(dir.toString());
    }

    static {
        VALUES = HalfAxis.values();
        _ZERO = null;
        CROSS_PRODUCTS = new HalfAxis[][]{{_ZERO, POS_Z, NEG_Y, _ZERO, NEG_Z, POS_Y}, {NEG_Z, _ZERO, POS_X, POS_Z, _ZERO, NEG_X}, {POS_Y, NEG_X, _ZERO, NEG_Y, POS_X, _ZERO}, {_ZERO, NEG_Z, POS_Y, _ZERO, POS_Z, NEG_Y}, {POS_Z, _ZERO, NEG_X, NEG_Z, _ZERO, POS_X}, {NEG_Y, POS_X, _ZERO, POS_Y, NEG_X, _ZERO}};
        NEGATIONS = new HalfAxis[]{POS_X, POS_Y, POS_Z, NEG_X, NEG_Y, NEG_Z};
    }
}

