/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.collect.Ordering;
import openmods.calc.BinaryOperator;
import openmods.calc.Calculator;
import openmods.calc.FractionParser;
import openmods.calc.ISymbol;
import openmods.calc.IValueParser;
import openmods.calc.OperatorDictionary;
import openmods.calc.TopFrame;
import openmods.calc.UnaryFunction;
import openmods.calc.UnaryOperator;
import openmods.config.simpler.Configurable;
import org.apache.commons.lang3.math.Fraction;

public class FractionCalculator
extends Calculator<Fraction> {
    private static final int MAX_PRIO = 5;
    @Configurable
    public boolean properFractions;
    @Configurable
    public boolean expand;

    public FractionCalculator() {
        super((IValueParser)new FractionParser(), (Object)Fraction.ZERO);
    }

    protected void setupOperators(OperatorDictionary<Fraction> operators) {
        operators.registerUnaryOperator("neg", new UnaryOperator<Fraction>(){

            protected Fraction execute(Fraction value) {
                return value.negate();
            }
        });
        operators.registerMixedOperator("+", new BinaryOperator<Fraction>(1){

            protected Fraction execute(Fraction left, Fraction right) {
                return left.add(right);
            }
        }, new UnaryOperator<Fraction>(){

            protected Fraction execute(Fraction value) {
                return value;
            }
        });
        operators.registerMixedOperator("-", new BinaryOperator<Fraction>(1){

            protected Fraction execute(Fraction left, Fraction right) {
                return left.subtract(right);
            }
        }, new UnaryOperator<Fraction>(){

            protected Fraction execute(Fraction value) {
                return value.negate();
            }
        });
        operators.registerBinaryOperator("*", new BinaryOperator<Fraction>(2){

            protected Fraction execute(Fraction left, Fraction right) {
                return left.multiplyBy(right);
            }
        });
        operators.registerBinaryOperator("/", new BinaryOperator<Fraction>(2){

            protected Fraction execute(Fraction left, Fraction right) {
                return left.divideBy(right);
            }
        });
    }

    private static Fraction createFraction(int value) {
        return Fraction.getFraction((int)value, (int)1);
    }

    protected void setupGlobals(TopFrame<Fraction> globals) {
        globals.setSymbol("abs", (ISymbol)((Object)new UnaryFunction<Fraction>(){

            protected Fraction execute(Fraction value) {
                return value.abs();
            }
        }));
        globals.setSymbol("sgn", (ISymbol)((Object)new UnaryFunction<Fraction>(){

            protected Fraction execute(Fraction value) {
                return FractionCalculator.createFraction(Integer.signum(value.getNumerator()));
            }
        }));
        globals.setSymbol("numerator", (ISymbol)((Object)new UnaryFunction<Fraction>(){

            protected Fraction execute(Fraction value) {
                return FractionCalculator.createFraction(value.getNumerator());
            }
        }));
        globals.setSymbol("denominator", (ISymbol)((Object)new UnaryFunction<Fraction>(){

            protected Fraction execute(Fraction value) {
                return FractionCalculator.createFraction(value.getDenominator());
            }
        }));
        globals.setSymbol("frac", (ISymbol)((Object)new UnaryFunction<Fraction>(){

            protected Fraction execute(Fraction value) {
                return Fraction.getFraction((int)value.getProperNumerator(), (int)value.getDenominator());
            }
        }));
        globals.setSymbol("int", (ISymbol)((Object)new UnaryFunction<Fraction>(){

            protected Fraction execute(Fraction value) {
                return FractionCalculator.createFraction(value.getProperWhole());
            }
        }));
        globals.setSymbol("sqrt", (ISymbol)((Object)new UnaryFunction<Fraction>(){

            protected Fraction execute(Fraction value) {
                return Fraction.getFraction((double)Math.sqrt(value.doubleValue()));
            }
        }));
        globals.setSymbol("log", (ISymbol)((Object)new UnaryFunction<Fraction>(){

            protected Fraction execute(Fraction value) {
                return Fraction.getFraction((double)Math.log(value.doubleValue()));
            }
        }));
        globals.setSymbol("min", (ISymbol)new Calculator.AccumulatorFunction(){

            protected Fraction accumulate(Fraction result, Fraction value) {
                return (Fraction)Ordering.natural().min((Object)result, (Object)value);
            }
        });
        globals.setSymbol("max", (ISymbol)new Calculator.AccumulatorFunction(){

            protected Fraction accumulate(Fraction result, Fraction value) {
                return (Fraction)Ordering.natural().max((Object)result, (Object)value);
            }
        });
    }

    public String toString(Fraction value) {
        if (this.expand) {
            return Double.toString(value.doubleValue());
        }
        return this.properFractions ? value.toProperString() : value.toString();
    }
}

