/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.miner;

import aroma1997.world.miner.Miners;
import aroma1997.world.miner.TileEntityMinerBase;
import aroma1997.world.miner.TileEntityMinerCore;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHLib")
public class TileEntityMinerRF
extends TileEntityMinerBase
implements IEnergyHandler {
    private static final int maxPerTick = 100;
    private int energybuffer;

    public TileEntityMinerRF() {
        super(Miners.RF);
    }

    @Override
    public void operate(TileEntityMinerCore minercore) {
        int amount = Math.min(minercore.getMaxEnergyBuffer() - minercore.getAmountFuel(), this.energybuffer);
        this.energybuffer -= amount;
        minercore.addToBuffer(amount);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("energybuffer", this.energybuffer);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energybuffer = nbt.func_74762_e("energybuffer");
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.energybuffer + maxReceive > 100) {
            int ret = 100 - this.energybuffer;
            if (!simulate) {
                this.energybuffer = 100;
            }
            return ret;
        }
        if (!simulate) {
            this.energybuffer += maxReceive;
        }
        return maxReceive;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energybuffer;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 100;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

