/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import openmods.Log;
import openmods.OpenMods;
import openmods.utils.SidedCommand;
import openperipheral.ArchitectureChecker;
import openperipheral.adapter.AdapterRegistry;
import openperipheral.adapter.FeatureGroupManager;
import openperipheral.adapter.composed.ComposedMethodsFactory;
import openperipheral.adapter.composed.IMethodMap;
import openperipheral.adapter.wrappers.AdapterWrapper;
import openperipheral.util.DocBuilder;

public class CommandDump
extends SidedCommand {
    private static final List<IArchSerializer> archSerializers = Lists.newArrayList();

    public CommandDump(String name, boolean restricted) {
        super(name, restricted);
    }

    public static void addArchSerializer(final String architecture, final String type, final DocBuilder.IClassDecorator decorator, final ComposedMethodsFactory<? extends IMethodMap> methods) {
        archSerializers.add(new IArchSerializer(){

            @Override
            public void serialize(DocBuilder builder) {
                for (Map.Entry e : methods.listCollectedClasses().entrySet()) {
                    builder.createDocForClass(architecture, type, decorator, e.getKey(), (IMethodMap)e.getValue());
                }
            }
        });
    }

    public String func_71518_a(ICommandSender sender) {
        return this.name + " <type> <file>";
    }

    private static void processExternalAdapters(DocBuilder builder, AdapterRegistry registry, String type) {
        for (Map.Entry<Class<?>, Collection<AdapterWrapper>> e : registry.listExternalAdapters().entrySet()) {
            Class<?> cls = e.getKey();
            for (AdapterWrapper w : e.getValue()) {
                builder.createDocForAdapter(type, "external", cls, w);
            }
        }
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        String format = args.length >= 1 ? args[0] : "xhtml";
        String name = args.length >= 2 ? args[1] : "openperipheral_docs";
        String filename = name + '.' + format;
        try {
            long start = System.currentTimeMillis();
            File output = new File(filename);
            if (!output.isAbsolute()) {
                output = new File(OpenMods.proxy.getMinecraftDir(), filename);
            }
            DocBuilder builder = new DocBuilder();
            builder.setRootAttribute("generatedIn", CommandDump.getModVersion());
            builder.setRootAttribute("generatedOn", CommandDump.getCurrentTime());
            builder.setRootAttribute("generatedBy", sender.func_70005_c_());
            Set<String> knownArchitectures = ArchitectureChecker.INSTANCE.knownArchitectures();
            for (String architecture : knownArchitectures) {
                boolean isEnabled = ArchitectureChecker.INSTANCE.isEnabled(architecture);
                builder.createDocForArchitecture(architecture, isEnabled);
            }
            for (String fg : FeatureGroupManager.INSTANCE.knownFeatureGroups()) {
                builder.createDocForFeatureGroup(fg, knownArchitectures, FeatureGroupManager.INSTANCE);
            }
            for (IArchSerializer serializer : archSerializers) {
                serializer.serialize(builder);
            }
            CommandDump.processExternalAdapters(builder, AdapterRegistry.PERIPHERAL_ADAPTERS, "peripheral");
            CommandDump.processExternalAdapters(builder, AdapterRegistry.OBJECT_ADAPTERS, "object");
            if (format.equalsIgnoreCase("xhtml")) {
                builder.dumpXml(output, true);
            } else if (format.equalsIgnoreCase("xml")) {
                builder.dumpXml(output, false);
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Invalid format: " + format));
                return;
            }
            long duration = System.currentTimeMillis() - start;
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("openperipheralcore.dump.done", new Object[]{format, output.getAbsolutePath(), duration}));
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Failed to execute dump command", (Object[])new Object[0]);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("openperipheralcore.dump.fail", new Object[0]));
        }
    }

    private static String getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        TimeZone tz = Calendar.getInstance().getTimeZone();
        dateFormat.setTimeZone(tz);
        return dateFormat.format(new Date());
    }

    private static String getModVersion() {
        try {
            return ((ModContainer)Loader.instance().getIndexedModList().get("OpenPeripheralCore")).getDisplayVersion();
        }
        catch (Exception e) {
            Log.info((Throwable)e, (String)"Failed to get OpenPeripheral version", (Object[])new Object[0]);
            return "unknown";
        }
    }

    public List<?> func_71516_a(ICommandSender icommandsender, String[] astring) {
        if (astring.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"xml", "xhtml"});
        }
        return null;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    private static interface IArchSerializer {
        public void serialize(DocBuilder var1);
    }
}

