/*
 * Decompiled with CFR 0.152.
 */
package vswe.production.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import vswe.production.item.ModItems;

public enum Upgrade {
    BLANK("Blank Upgrade", "Crafting component", new MaxCount(0), (ParentType)null),
    AUTO_CRAFTER("Auto Crafter", "Convert a crafting table into an auto crafting table", new MaxCount(1), ParentType.CRAFTING),
    STORAGE("Extra Storage", "Adds extra storage", new MaxCount(1), ParentType.CRAFTING),
    CHARGED("Charger", "Let idle components charge up for later", new ConfigurableMax(8)),
    SPEED("Production Speed", "Increase the production speed", new ConfigurableMax(8)),
    QUEUE("Input Queue", "Adds an input queue", new MaxCount(3), ParentType.SMELTING),
    EFFICIENCY("Fuel Efficiency", "Improves the fuel efficiency of solid fuel types", (MaxCount)new ConfigurableMax(4), ParentType.GLOBAL),
    LAVA("Lava Generator", "Allows lava to be used as fuel", new MaxCount(1), ParentType.GLOBAL),
    SOLAR("Solar Generator", "Allows the table to be charged by solar power", (MaxCount)new ConfigurableMax(1), ParentType.GLOBAL),
    AUTO_TRANSFER("Auto Transfer", "Enables auto transfer to and from the table", new MaxCount(1), ParentType.GLOBAL),
    FILTER("Filter", "Enables transfer filters", new MaxCount(1), ParentType.GLOBAL),
    TRANSFER("Transfer Capacity", "Increases the automatic transfer capacity", (MaxCount)new ConfigurableMax(6, 20), ParentType.GLOBAL);

    private String unlocalizedName;
    private String name;
    private String description;
    private MaxCount maxCount;
    private EnumSet<ParentType> validParents;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;

    private Upgrade(String name, String description, MaxCount maxCount, EnumSet<ParentType> validParents) {
        this.name = name;
        this.validParents = validParents;
        this.unlocalizedName = this.toString().toLowerCase();
        this.description = description;
        this.maxCount = maxCount;
        maxCount.init(this);
    }

    private Upgrade(String name, String description, MaxCount maxCount, ParentType type) {
        this(name, description, maxCount, type == null ? EnumSet.noneOf(ParentType.class) : EnumSet.of(type));
    }

    private Upgrade(String name, String description, MaxCount maxCount) {
        this(name, description, maxCount, EnumSet.of(ParentType.CRAFTING, ParentType.SMELTING));
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public boolean isEnabled() {
        return this.maxCount.getConfigurableMax() == 0 || this.maxCount.getMax() > 0;
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcon(IIconRegister register) {
        this.icon = register.func_94245_a("production:" + this.unlocalizedName);
    }

    public ItemStack getItemStack() {
        return new ItemStack((Item)ModItems.upgrade, 1, this.ordinal());
    }

    public static ItemStack getInvalidItemStack() {
        return new ItemStack((Item)ModItems.upgrade, 1, Upgrade.values().length);
    }

    public void addInfo(List<String> info) {
        info.add(EnumChatFormatting.GRAY + this.description);
        if (GuiScreen.func_146272_n()) {
            if (this.getMaxCount() == 1) {
                info.add(EnumChatFormatting.YELLOW + "Doesn't stack well");
            } else if (this.getMaxCount() > 1) {
                info.add(EnumChatFormatting.YELLOW + "Stacks well up to " + this.getMaxCount() + " items");
            } else if (!this.isEnabled()) {
                info.add(EnumChatFormatting.DARK_RED + "This item is disabled");
            }
            for (ParentType validParent : this.validParents) {
                info.add(EnumChatFormatting.GOLD + validParent.description);
            }
        }
    }

    public boolean isValid(ItemStack parent) {
        for (ParentType validParent : this.validParents) {
            if (!validParent.isValidParent(parent)) continue;
            return true;
        }
        return false;
    }

    public int getMaxCount() {
        return this.maxCount.getMax();
    }

    public MaxCount getMaxCountObject() {
        return this.maxCount;
    }

    private static class ConfigurableMax
    extends MaxCount {
        private boolean isGlobal;
        private int configurableMax;
        private static final int GLOBAL_MAX_COUNT = 512;
        private static final int MAX_COUNT = 448;

        private ConfigurableMax(int max, int configurableMax) {
            super(max);
            this.configurableMax = configurableMax;
        }

        private ConfigurableMax(int max) {
            this(max, -1);
        }

        @Override
        public int getConfigurableMax() {
            return this.configurableMax != -1 ? this.configurableMax : (this.isGlobal ? 512 : 448);
        }

        @Override
        public void init(Upgrade upgrade) {
            this.isGlobal = upgrade.validParents.contains((Object)ParentType.GLOBAL);
        }
    }

    public static class MaxCount {
        private int max;
        private int defaultMax;

        public MaxCount(int max) {
            this.max = max;
            this.defaultMax = max;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int value) {
            this.max = value;
        }

        public int getConfigurableMax() {
            return this.defaultMax;
        }

        public void init(Upgrade upgrade) {
        }
    }

    public static enum ParentType {
        CRAFTING("Works with Crafting Tables"){

            @Override
            protected boolean isValidParent(ItemStack item) {
                return item != null && Item.func_150898_a((Block)Blocks.field_150462_ai).equals(item.func_77973_b());
            }
        }
        ,
        SMELTING("Works with Furnaces"){

            @Override
            protected boolean isValidParent(ItemStack item) {
                return item != null && Item.func_150898_a((Block)Blocks.field_150460_al).equals(item.func_77973_b());
            }
        }
        ,
        GLOBAL("Upgrades the entire Production Table"){

            @Override
            protected boolean isValidParent(ItemStack item) {
                return item == null;
            }
        };

        private String description;

        private ParentType(String description) {
            this.description = description;
        }

        protected abstract boolean isValidParent(ItemStack var1);
    }
}

