/*
 * Decompiled with CFR 0.152.
 */
package vswe.production.gui.container.slot;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import vswe.production.gui.GuiBase;
import vswe.production.page.setting.Transfer;
import vswe.production.tileentity.TileEntityTable;

public class SlotBase
extends Slot {
    private int x;
    private int y;
    private Transfer[] input = new Transfer[6];
    private Transfer[] output = new Transfer[6];
    protected TileEntityTable table;

    public SlotBase(IInventory inventory, TileEntityTable table, int id, int x, int y) {
        super(inventory, id, x, y);
        this.x = x;
        this.y = y;
        this.table = table;
    }

    public void updateClient(boolean visible) {
        if (visible && this.isEnabled()) {
            this.field_75223_e = this.getX();
            this.field_75221_f = this.getY();
        } else {
            this.field_75223_e = -9000;
            this.field_75221_f = -9000;
        }
    }

    public void updateServer() {
        if (!this.isEnabled() && this.func_75216_d()) {
            this.table.spitOutItem(this.func_75211_c());
            this.func_75215_d(null);
        }
    }

    public boolean func_75214_a(ItemStack itemstack) {
        return this.isEnabled();
    }

    public boolean isVisible() {
        return this.table.getMenu() == null;
    }

    public boolean isEnabled() {
        return true;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getTextureIndex(GuiBase gui) {
        return this.isEnabled() ? 0 : 1;
    }

    public boolean isBig() {
        return false;
    }

    public boolean isOutputValid(int id, ItemStack item) {
        return this.output[id] != null && this.output[id].isValid(this.table, item);
    }

    public boolean isInputValid(int id, ItemStack item) {
        return this.input[id] != null && this.input[id].isValid(this.table, item);
    }

    public void resetValidity(int id) {
        this.output[id] = null;
        this.input[id] = null;
    }

    public void setValidity(int id, Transfer input, Transfer output) {
        this.output[id] = output;
        this.input[id] = input;
    }

    public boolean canAcceptItems() {
        return true;
    }

    public boolean canSupplyItems() {
        return true;
    }

    public boolean canAcceptItem(ItemStack item) {
        return true;
    }

    public int func_75219_a() {
        return this.getSlotStackLimit(null);
    }

    public int getSlotStackLimit(ItemStack item) {
        return super.func_75219_a();
    }

    public boolean canPickUpOnDoubleClick() {
        return this.isVisible() && this.isEnabled();
    }

    public boolean canDragIntoSlot() {
        return true;
    }

    public boolean canShiftClickInto(ItemStack item) {
        return true;
    }

    public boolean shouldSlotHighlightItems() {
        return true;
    }

    public boolean shouldSlotHighlightSelf() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean shouldHighlight(SlotBase slot, SlotBase other) {
        return Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null && slot != null && !slot.func_75216_d() && other != null && other.func_75216_d() && slot.func_75214_a(other.func_75211_c()) && slot.getSlotStackLimit(other.func_75211_c()) > (slot.func_75216_d() ? slot.func_75211_c().field_77994_a : 0);
    }

    public boolean shouldDropOnClosing() {
        return true;
    }
}

