/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.aspect;

import java.util.Collections;
import java.util.List;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import modtweaker2.mods.thaumcraft.aspect.AspectStack;
import modtweaker2.mods.thaumcraft.aspect.IAspectDefinition;
import modtweaker2.mods.thaumcraft.aspect.IAspectStack;
import modtweaker2.mods.thaumcraft.aspect.MCAspectDefinition;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.AspectList;

public class MCAspectStack
implements IAspectStack {
    private final AspectStack stack;
    private final List<IAspectStack> aspects;

    public MCAspectStack(AspectStack stack) {
        if (stack == null) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = stack;
        this.aspects = Collections.singletonList(this);
    }

    public IItemStack applyTransform(IItemStack arg0, IPlayer arg1) {
        return null;
    }

    public boolean contains(IIngredient ingredient) {
        if (ingredient instanceof MCAspectStack) {
            List<IAspectStack> aspects = ((MCAspectStack)ingredient).getAspects();
            if (aspects == null || aspects.size() != 1) {
                return false;
            }
            return this.matches(aspects.get(0));
        }
        List iitems = ingredient.getItems();
        if (iitems == null || iitems.size() != 1) {
            return false;
        }
        return this.matches((IItemStack)iitems.get(0));
    }

    public int getAmount() {
        return this.stack.amount;
    }

    public Object getInternal() {
        return this.stack;
    }

    public List<IItemStack> getItems() {
        return null;
    }

    @Override
    public List<IAspectStack> getAspects() {
        return this.aspects;
    }

    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    public String getMark() {
        return null;
    }

    public boolean hasTransformers() {
        return false;
    }

    public IIngredient marked(String arg0) {
        return null;
    }

    public boolean matches(IItemStack item) {
        ItemStack internal = MineTweakerMC.getItemStack((IItemStack)item);
        if (internal != null) {
            AspectList itemAspectList = new AspectList(internal);
            if (itemAspectList.aspects.keySet().contains(this.stack.aspect.getTag())) {
                return true;
            }
        }
        return false;
    }

    public boolean matches(IAspectStack aspect) {
        Object internal;
        return aspect != null && (internal = aspect.getInternal()) != null && internal instanceof AspectStack && this.stack.aspect.getTag().equals(((AspectStack)internal).aspect.getTag());
    }

    public boolean matches(ILiquidStack arg0) {
        return false;
    }

    public IIngredient only(IItemCondition arg0) {
        return null;
    }

    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr((IIngredient)this, ingredient);
    }

    public IIngredient transform(IItemTransformer arg0) {
        return null;
    }

    @Override
    public IAspectDefinition getDefinition() {
        return new MCAspectDefinition(this.stack);
    }

    @Override
    public String getName() {
        return this.stack.aspect.getTag();
    }

    @Override
    public String getDisplayName() {
        return this.stack.aspect.getName();
    }

    @Override
    public IAspectStack amount(int amount) {
        return this.withAmount(amount);
    }

    @Override
    public IAspectStack withAmount(int amount) {
        AspectStack result = new AspectStack(this.stack.aspect, amount);
        return new MCAspectStack(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<aspect:").append(this.stack.aspect.getName()).append('>');
        if (this.stack.amount > 1) {
            sb.append(" * ").append(this.stack.amount);
        }
        return sb.toString();
    }
}

