/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import openmods.Log;
import openperipheral.adapter.IMethodCall;
import openperipheral.api.architecture.IArchitecture;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.converter.IConverter;
import openperipheral.api.helpers.Index;
import openperipheral.interfaces.cc.wrappers.LuaObjectWrapper;
import org.apache.logging.log4j.Level;

public class ComputerCraftEnv {
    private final IConverter converter;

    public ComputerCraftEnv(IConverter converter) {
        this.converter = converter;
    }

    public IArchitectureAccess createAccess(IComputerAccess access) {
        return new CCArchitectureAccess(access, this.converter);
    }

    private IMethodCall addCommonArgs(IMethodCall call, ILuaContext context) {
        return call.setEnv("converter", this.converter).setEnv("context", context);
    }

    public IMethodCall addObjectArgs(IMethodCall call, ILuaContext context) {
        return this.addCommonArgs(call, context).setEnv("architecture", new CCArchitecture(this.converter));
    }

    public IMethodCall addPeripheralArgs(IMethodCall call, IComputerAccess access, ILuaContext context) {
        CCArchitectureAccess wrapper = new CCArchitectureAccess(access, this.converter);
        return this.addCommonArgs(call, context).setEnv("architecture", wrapper).setEnv("access", wrapper).setEnv("computer", access);
    }

    private static class CCArchitectureAccess
    extends CCArchitecture
    implements IArchitectureAccess {
        private final IComputerAccess access;

        public CCArchitectureAccess(IComputerAccess access, IConverter converter) {
            super(converter);
            this.access = access;
        }

        @Override
        public String callerName() {
            return Integer.toString(this.access.getID());
        }

        @Override
        public String peripheralName() {
            return this.access.getAttachmentName();
        }

        @Override
        public boolean canSignal() {
            try {
                this.access.getAttachmentName();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public boolean signal(String name, Object ... args) {
            try {
                this.access.queueEvent(name, args);
                return true;
            }
            catch (Exception e) {
                Log.log((Level)Level.DEBUG, (Throwable)e, (String)"Failed to send signal: %s", (Object[])new Object[]{name});
                return false;
            }
        }
    }

    private static class CCArchitecture
    implements IArchitecture {
        private final IConverter converter;

        public CCArchitecture(IConverter converter) {
            this.converter = converter;
        }

        @Override
        public String architecture() {
            return "ComputerCraft";
        }

        @Override
        public Object wrapObject(Object target) {
            return LuaObjectWrapper.wrap(target);
        }

        @Override
        public Index createIndex(int value) {
            return Index.fromJava(value, 1);
        }

        @Override
        public IConverter getConverter() {
            return this.converter;
        }
    }
}

