/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.ILightingController;
import com.xcompwiz.mystcraft.instability.InstabilityData;
import com.xcompwiz.mystcraft.symbol.SymbolBase;

public class SymbolLightingBright
extends SymbolBase {
    public SymbolLightingBright(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        controller.registerInterface(new LightingController());
    }

    @Override
    public int instabilityModifier(int count) {
        return InstabilityData.symbol.bright;
    }

    private class LightingController
    implements ILightingController {
        private LightingController() {
        }

        @Override
        public void generateLightBrightnessTable(float[] lightBrightnessTable) {
            float f = 0.25f;
            for (int i = 0; i < lightBrightnessTable.length; ++i) {
                float f1 = 1.0f - (float)i / 15.0f;
                lightBrightnessTable[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
            }
        }

        @Override
        public int scaleLighting(int blockLightValue) {
            return blockLightValue + (15 - blockLightValue) / 2;
        }
    }
}

