/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.api.item.IItemOrderablePageProvider;
import com.xcompwiz.mystcraft.api.item.IItemPageCollection;
import com.xcompwiz.mystcraft.api.item.IItemRenameable;
import com.xcompwiz.mystcraft.inventory.ContainerBase;
import com.xcompwiz.mystcraft.inventory.PageCollectionPageReceiver;
import com.xcompwiz.mystcraft.inventory.SlotBanned;
import com.xcompwiz.mystcraft.inventory.SlotCollection;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerFolder
extends ContainerBase
implements IGuiMessageHandler,
PageCollectionPageReceiver.IItemProvider {
    private InventoryPlayer playerinv;
    private int slot;

    public ContainerFolder(InventoryPlayer inventoryplayer, int slot) {
        this.playerinv = inventoryplayer;
        this.slot = slot;
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 135 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            if (slot == j) {
                this.func_75146_a(new SlotBanned((IInventory)inventoryplayer, j, 8 + j * 18, 193));
            }
            this.func_75146_a(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 193));
        }
        SlotCollection maininv = null;
        SlotCollection hotbar = null;
        maininv = new SlotCollection(this, 0, 27);
        hotbar = new SlotCollection(this, 27, 36);
        PageCollectionPageReceiver pagecollectionreceiver = new PageCollectionPageReceiver(this, this.playerinv.field_70458_d);
        maininv.pushTargetFront(hotbar);
        maininv.pushTargetFront(pagecollectionreceiver);
        hotbar.pushTargetFront(maininv);
        hotbar.pushTargetFront(pagecollectionreceiver);
        this.collections.add(maininv);
        this.collections.add(hotbar);
    }

    @Override
    public ItemStack getPageCollection() {
        return this.getInventoryItem();
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public String getTabItemName() {
        ItemStack itemstack = this.getInventoryItem();
        if (itemstack == null) {
            return null;
        }
        if (itemstack.func_77973_b() instanceof IItemRenameable) {
            return ((IItemRenameable)itemstack.func_77973_b()).getDisplayName(this.playerinv.field_70458_d, itemstack);
        }
        return null;
    }

    public ItemStack getInventoryItem() {
        return this.playerinv.func_70301_a(this.slot);
    }

    @Override
    public void processMessage(EntityPlayer player, NBTTagCompound data) {
        if (data.func_74764_b("RemoveFromCollection")) {
            if (player.field_71071_by.func_70445_o() != null) {
                return;
            }
            ItemStack page = ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("RemoveFromCollection"));
            ItemStack itemstack = this.removePageFromSurface(player, this.getInventoryItem(), page);
            player.field_71071_by.func_70437_b(itemstack);
        }
        if (data.func_74764_b("RemoveFromOrderedCollection")) {
            if (player.field_71071_by.func_70445_o() != null) {
                return;
            }
            int index = data.func_74762_e("RemoveFromOrderedCollection");
            player.field_71071_by.func_70437_b(this.removePageFromSurface(player, this.getInventoryItem(), index));
        }
        if (data.func_74764_b("AddToSurface")) {
            if (player.field_71071_by.func_70445_o() == null) {
                return;
            }
            if (!data.func_74764_b("Index")) {
                return;
            }
            if (this.getInventoryItem() == null) {
                return;
            }
            boolean single = data.func_74767_n("Single");
            int index = data.func_74762_e("Index");
            if (single) {
                ItemStack stack = player.field_71071_by.func_70445_o();
                ItemStack clone = stack.func_77946_l();
                clone.field_77994_a = 1;
                ItemStack returned = this.placePageOnSurface(player, this.getInventoryItem(), clone, index);
                if (returned == null || stack.field_77994_a == 1) {
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) {
                        stack = returned;
                    }
                    player.field_71071_by.func_70437_b(stack);
                } else {
                    this.placePageOnSurface(player, this.getInventoryItem(), returned, index);
                }
            } else {
                player.field_71071_by.func_70437_b(this.placePageOnSurface(player, this.getInventoryItem(), player.field_71071_by.func_70445_o(), index));
            }
        }
    }

    private ItemStack placePageOnSurface(EntityPlayer player, ItemStack itemstack, ItemStack page, int index) {
        if (itemstack == null) {
            return page;
        }
        ItemStack result = page;
        if (itemstack.func_77973_b() instanceof IItemPageCollection) {
            result = ((IItemPageCollection)itemstack.func_77973_b()).addPage(player, itemstack, page);
        }
        if (itemstack.func_77973_b() instanceof IItemOrderablePageProvider) {
            result = ((IItemOrderablePageProvider)itemstack.func_77973_b()).setPage(player, itemstack, page, index);
        }
        if (result == page) {
            return result;
        }
        return result;
    }

    private ItemStack removePageFromSurface(EntityPlayer player, ItemStack itemstack, int index) {
        if (itemstack == null) {
            return null;
        }
        ItemStack result = null;
        if (itemstack.func_77973_b() instanceof IItemOrderablePageProvider) {
            result = ((IItemOrderablePageProvider)itemstack.func_77973_b()).removePage(player, itemstack, index);
        }
        if (result == null) {
            return result;
        }
        return result;
    }

    private ItemStack removePageFromSurface(EntityPlayer player, ItemStack itemstack, ItemStack page) {
        if (itemstack == null) {
            return null;
        }
        ItemStack result = null;
        if (itemstack.func_77973_b() instanceof IItemPageCollection) {
            result = ((IItemPageCollection)itemstack.func_77973_b()).remove(player, itemstack, page);
        }
        if (result == null) {
            return result;
        }
        return result;
    }

    public static class Messages {
        public static final String AddToSurface = "AddToSurface";
        public static final String RemoveFromOrderedCollection = "RemoveFromOrderedCollection";
        public static final String RemoveFromCollection = "RemoveFromCollection";
    }
}

