/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.render;

import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class WeatherRendererMyst
extends IRenderHandler {
    private static final ResourceLocation locationRainPng = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation locationSnowPng = new ResourceLocation("textures/environment/snow.png");
    private int rendererUpdateCount;
    private float[] rainXCoords;
    private float[] rainYCoords;
    private Random random = new Random();

    public WeatherRendererMyst(WorldProviderMyst provider, AgeController controller) {
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float partialTicks, WorldClient worldObj, Minecraft mc) {
        float rain_strength = worldObj.func_72867_j(partialTicks);
        if (rain_strength > 0.0f) {
            mc.field_71460_t.func_78463_b((double)partialTicks);
            if (this.rainXCoords == null) {
                this.rainXCoords = new float[1024];
                this.rainYCoords = new float[1024];
                for (int x = 0; x < 32; ++x) {
                    for (int z = 0; z < 32; ++z) {
                        float x2 = z - 16;
                        float z2 = x - 16;
                        float distance = MathHelper.func_76129_c((float)(x2 * x2 + z2 * z2));
                        this.rainXCoords[x << 5 | z] = -z2 / distance;
                        this.rainYCoords[x << 5 | z] = x2 / distance;
                    }
                }
            }
            GL11.glPushMatrix();
            GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            EntityLivingBase entitylivingbase = mc.field_71451_h;
            WorldClient worldclient = worldObj;
            int entityX = MathHelper.func_76128_c((double)entitylivingbase.field_70165_t);
            int entityY = MathHelper.func_76128_c((double)entitylivingbase.field_70163_u);
            int entityZ = MathHelper.func_76128_c((double)entitylivingbase.field_70161_v);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.01f);
            mc.func_110434_K().func_110577_a(locationSnowPng);
            double smoothedX = entitylivingbase.field_70142_S + (entitylivingbase.field_70165_t - entitylivingbase.field_70142_S) * (double)partialTicks;
            double smoothedY = entitylivingbase.field_70137_T + (entitylivingbase.field_70163_u - entitylivingbase.field_70137_T) * (double)partialTicks;
            double smoothedZ = entitylivingbase.field_70136_U + (entitylivingbase.field_70161_v - entitylivingbase.field_70136_U) * (double)partialTicks;
            int ismoothedY = MathHelper.func_76128_c((double)smoothedY);
            int iteration_count = 5;
            if (mc.field_71474_y.field_74347_j) {
                iteration_count = 10;
            }
            int pass_param = -1;
            float softTick = (float)this.rendererUpdateCount + partialTicks;
            if (mc.field_71474_y.field_74347_j) {
                iteration_count = 10;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int zPos = entityZ - iteration_count; zPos <= entityZ + iteration_count; ++zPos) {
                for (int xPos = entityX - iteration_count; xPos <= entityX + iteration_count; ++xPos) {
                    float rate;
                    int coords = (zPos - entityZ + 16) * 32 + xPos - entityX + 16;
                    float rainX = this.rainXCoords[coords] * 0.5f;
                    float rainZ = this.rainYCoords[coords] * 0.5f;
                    BiomeGenBase biomegenbase = worldclient.func_72807_a(xPos, zPos);
                    if (!biomegenbase.func_76738_d() && !biomegenbase.func_76746_c()) continue;
                    int height = worldclient.func_72874_g(xPos, zPos);
                    int lowY = entityY - iteration_count;
                    int higY = entityY + iteration_count;
                    if (lowY < height) {
                        lowY = height;
                    }
                    if (higY < height) {
                        higY = height;
                    }
                    float scale = 1.0f;
                    int i3 = height;
                    if (height < ismoothedY) {
                        i3 = ismoothedY;
                    }
                    if (lowY == higY) continue;
                    this.random.setSeed(xPos * xPos * 3121 + xPos * 45238971 ^ zPos * zPos * 418711 + zPos * 13761);
                    float temperature = biomegenbase.func_150564_a(xPos, lowY, zPos);
                    if (worldclient.func_72959_q().func_76939_a(temperature, height) >= 0.15f) {
                        if (pass_param != 0) {
                            if (pass_param >= 0) {
                                tessellator.func_78381_a();
                            }
                            pass_param = 0;
                            mc.func_110434_K().func_110577_a(locationRainPng);
                            tessellator.func_78382_b();
                        }
                        rate = ((float)(this.rendererUpdateCount + xPos * xPos * 3121 + xPos * 45238971 + zPos * zPos * 418711 + zPos * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                        double xOffset = (double)((float)xPos + 0.5f) - entitylivingbase.field_70165_t;
                        double zOffset = (double)((float)zPos + 0.5f) - entitylivingbase.field_70161_v;
                        float distance = MathHelper.func_76133_a((double)(xOffset * xOffset + zOffset * zOffset)) / (float)iteration_count;
                        tessellator.func_78380_c(worldclient.func_72802_i(xPos, i3, zPos, 0));
                        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, ((1.0f - distance * distance) * 0.5f + 0.5f) * rain_strength);
                        tessellator.func_78373_b(-smoothedX * 1.0, -smoothedY * 1.0, -smoothedZ * 1.0);
                        tessellator.func_78374_a((double)((float)xPos - rainX) + 0.5, (double)lowY, (double)((float)zPos - rainZ) + 0.5, (double)(0.0f * scale), (double)((float)lowY * scale / 4.0f + rate * scale));
                        tessellator.func_78374_a((double)((float)xPos + rainX) + 0.5, (double)lowY, (double)((float)zPos + rainZ) + 0.5, (double)(1.0f * scale), (double)((float)lowY * scale / 4.0f + rate * scale));
                        tessellator.func_78374_a((double)((float)xPos + rainX) + 0.5, (double)higY, (double)((float)zPos + rainZ) + 0.5, (double)(1.0f * scale), (double)((float)higY * scale / 4.0f + rate * scale));
                        tessellator.func_78374_a((double)((float)xPos - rainX) + 0.5, (double)higY, (double)((float)zPos - rainZ) + 0.5, (double)(0.0f * scale), (double)((float)higY * scale / 4.0f + rate * scale));
                        tessellator.func_78373_b(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (pass_param != 1) {
                        if (pass_param >= 0) {
                            tessellator.func_78381_a();
                        }
                        pass_param = 1;
                        mc.func_110434_K().func_110577_a(locationSnowPng);
                        tessellator.func_78382_b();
                    }
                    rate = ((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    float drift = this.random.nextFloat() + softTick * 0.01f * (float)this.random.nextGaussian();
                    float variable_rate = this.random.nextFloat() + softTick * (float)this.random.nextGaussian() * 0.001f;
                    double xOffset = (double)((float)xPos + 0.5f) - entitylivingbase.field_70165_t;
                    double zOffset = (double)((float)zPos + 0.5f) - entitylivingbase.field_70161_v;
                    float distance = MathHelper.func_76133_a((double)(xOffset * xOffset + zOffset * zOffset)) / (float)iteration_count;
                    tessellator.func_78380_c((worldclient.func_72802_i(xPos, i3, zPos, 0) * 3 + 0xF000F0) / 4);
                    tessellator.func_78369_a(1.0f, 1.0f, 1.0f, ((1.0f - distance * distance) * 0.3f + 0.5f) * rain_strength);
                    tessellator.func_78373_b(-smoothedX * 1.0, -smoothedY * 1.0, -smoothedZ * 1.0);
                    tessellator.func_78374_a((double)((float)xPos - rainX) + 0.5, (double)lowY, (double)((float)zPos - rainZ) + 0.5, (double)(0.0f * scale + drift), (double)((float)lowY * scale / 4.0f + rate * scale + variable_rate));
                    tessellator.func_78374_a((double)((float)xPos + rainX) + 0.5, (double)lowY, (double)((float)zPos + rainZ) + 0.5, (double)(1.0f * scale + drift), (double)((float)lowY * scale / 4.0f + rate * scale + variable_rate));
                    tessellator.func_78374_a((double)((float)xPos + rainX) + 0.5, (double)higY, (double)((float)zPos + rainZ) + 0.5, (double)(1.0f * scale + drift), (double)((float)higY * scale / 4.0f + rate * scale + variable_rate));
                    tessellator.func_78374_a((double)((float)xPos - rainX) + 0.5, (double)higY, (double)((float)zPos - rainZ) + 0.5, (double)(0.0f * scale + drift), (double)((float)higY * scale / 4.0f + rate * scale + variable_rate));
                    tessellator.func_78373_b(0.0, 0.0, 0.0);
                }
            }
            if (pass_param >= 0) {
                tessellator.func_78381_a();
            }
            GL11.glPopMatrix();
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            mc.field_71460_t.func_78483_a((double)partialTicks);
        }
    }

    public void updateClouds() {
        ++this.rendererUpdateCount;
    }
}

