/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.uv.IconTransformation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import mrtjp.projectred.transmission.WireModelGen$;
import mrtjp.projectred.transmission.WirePart;
import net.minecraft.util.IIcon;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class RenderWire$ {
    public static final RenderWire$ MODULE$;
    private final CCModel[] wireModels;
    private final CCModel[] invModels;

    static {
        new RenderWire$();
    }

    public CCModel[] wireModels() {
        return this.wireModels;
    }

    public CCModel[] invModels() {
        return this.invModels;
    }

    public int modelKey(int side, int thickness, int connMap) {
        int key = connMap & 0xFF;
        int renderCorner = connMap >> 20 & 0xF;
        key |= (renderCorner ^ key & 0xF) << 4;
        key &= ~15 | renderCorner;
        int internal = (connMap & 0xF00) >> 8;
        key |= internal << 4 | internal;
        return key |= side + thickness * 6 << 8;
    }

    public int modelKey(WirePart w) {
        return this.modelKey(w.side(), w.getThickness(), w.connMap());
    }

    /*
     * WARNING - void declaration
     */
    public CCModel getOrGenerateModel(int key) {
        void var2_2;
        CCModel m = this.wireModels()[key];
        if (m == null) {
            this.wireModels()[key] = m = WireModelGen$.MODULE$.generateModel(key, false);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CCModel getOrGenerateInvModel(int thickness) {
        void var2_2;
        CCModel m = this.invModels()[thickness];
        if (m == null) {
            this.invModels()[thickness] = m = WireModelGen$.MODULE$.generateInvModel(thickness);
        }
        return var2_2;
    }

    public void render(WirePart w, Vector3 pos) {
        this.getOrGenerateModel(this.modelKey(w)).render(new CCRenderState.IVertexOperation[]{pos.translation(), new IconTransformation(w.getIcon()), ColourMultiplier.instance((int)w.renderHue())});
    }

    public void renderInv(int thickness, int hue, Seq<CCRenderState.IVertexOperation> ops) {
        this.getOrGenerateInvModel(thickness).render((CCRenderState.IVertexOperation[])((TraversableOnce)ops.$colon$plus((Object)ColourMultiplier.instance((int)hue), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(CCRenderState.IVertexOperation.class)));
    }

    public void renderBreakingOverlay(IIcon icon, WirePart wire) {
        int key = this.modelKey(wire);
        int side = (key >> 8) % 6;
        double w = (double)((key >> 8) / 6 + 1) / 16.0;
        double h = w + 0.0625;
        int mask = key & 0xFF;
        int connMask = (mask & 0xF0) >> 4 | mask & 0xF;
        int connCount = WireModelGen$.MODULE$.countConnections(connMask);
        Builder boxes = package$.MODULE$.Vector().newBuilder();
        boxes.$plus$eq((Object)new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, h, 0.5 + w).apply(Rotation.sideRotations[side].at(Vector3.center)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1)new Serializable(side, w, h, connMask, connCount, boxes){
            private final int side$1;
            private final double w$1;
            private final double h$1;
            private final int connMask$1;
            private final int connCount$1;
            private final Builder boxes$1;

            public final Object apply(int r) {
                BoxedUnit boxedUnit;
                int length;
                int n = this.connCount$1 == 0 ? (r % 2 == 1 ? 4 : 0) : (this.connCount$1 == 1 ? (this.connMask$1 == 1 << (r + 2) % 4 ? 4 : (this.connMask$1 == 1 << r ? 8 : 0)) : (length = (this.connMask$1 & 1 << r) != 0 ? 8 : 0));
                if (length > 0) {
                    double l = (double)length / 16.0;
                    boxedUnit = this.boxes$1.$plus$eq((Object)new Cuboid6(0.5 - this.w$1, 0.0, 0.5 + this.w$1, 0.5 + this.w$1, this.h$1, 0.5 + l).apply(Rotation.sideOrientation((int)this.side$1, (int)r).at(Vector3.center)));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.side$1 = side$1;
                this.w$1 = w$1;
                this.h$1 = h$1;
                this.connMask$1 = connMask$1;
                this.connCount$1 = connCount$1;
                this.boxes$1 = boxes$1;
            }
        });
        CCRenderState.setPipeline((CCRenderState.IVertexOperation[])new CCRenderState.IVertexOperation[]{new Translation((double)wire.x(), (double)wire.y(), (double)wire.z()), new IconTransformation(icon)});
        ((IterableLike)boxes.result()).foreach((Function1)new Serializable(){

            public final void apply(Cuboid6 box) {
                BlockRenderer.renderCuboid((Cuboid6)box, (int)0);
            }
        });
    }

    private RenderWire$() {
        MODULE$ = this;
        this.wireModels = new CCModel[4608];
        this.invModels = new CCModel[3];
    }
}

