/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils.helpers;

import com.google.common.base.Strings;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.utils.HeadUtils;
import ganymedes01.headcrumbs.utils.helpers.LycanitesHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.info.MobInfo;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LycanitesHelperClient {
    private static final Map<String, ResourceLocation> map = new HashMap<String, ResourceLocation>();

    public static ModelBase getModel(String name) {
        return AssetManager.getModel((String)name);
    }

    public static ResourceLocation getTexture(String name) {
        GroupInfo group;
        MobInfo info;
        if (!SkullTypes.lycanites.canShow()) {
            return null;
        }
        ResourceLocation tex = map.get(name);
        if (tex == null && (info = ObjectManager.getMobInfo((String)name)) != null && (group = info.group) != null) {
            tex = new ResourceLocation(group.filename, "textures/entity/" + name + ".png");
            map.put(name, tex);
        }
        return tex;
    }

    public static List<ItemStack> getStacks() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String mob : ObjectManager.mobs.keySet()) {
            if (Strings.isNullOrEmpty((String)mob) || LycanitesHelper.blacklist.contains(mob.toLowerCase())) continue;
            list.add(LycanitesHelperClient.getStackFor(mob));
        }
        return list;
    }

    private static ItemStack getStackFor(String mob) {
        ItemStack stack = HeadUtils.createHeadFor(mob);
        stack.func_77964_b(SkullTypes.lycanites.ordinal());
        return stack;
    }
}

