/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.network.packet;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.network.PacketHandler;
import ganymedes01.headcrumbs.network.packet.CustomPacket;
import ganymedes01.headcrumbs.utils.TextureUtils;
import ganymedes01.headcrumbs.utils.helpers.EtFuturumHelper;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class TextureSendPacket
extends CustomPacket {
    private GameProfile profile;

    public TextureSendPacket() {
        super(PacketHandler.PacketType.TEXTURE_SEND);
    }

    public TextureSendPacket(GameProfile profile) {
        this();
        this.profile = profile;
    }

    @Override
    public void writeData(ByteBuf buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.profile);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    @Override
    public void readData(ByteBuf buffer) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buffer);
        this.profile = NBTUtil.func_152459_a((NBTTagCompound)nbt);
    }

    @Override
    public void handleClientSide(World world, EntityPlayer player) {
        SkinManager skinManager = Minecraft.func_71410_x().func_152342_ad();
        Map map = skinManager.func_152788_a(this.profile);
        for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
            if (!map.containsKey(type)) continue;
            skinManager.func_152789_a((MinecraftProfileTexture)map.get(type), type, this.getCallback(type));
        }
    }

    @Override
    public void handleServerSide(World world, EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    private SkinManager.SkinAvailableCallback getCallback(MinecraftProfileTexture.Type type) {
        if (Headcrumbs.use18PlayerModel) {
            return EtFuturumHelper.getSkinDownloadCallback(this.profile.getName());
        }
        return new SkinManager.SkinAvailableCallback(){

            public void func_152121_a(MinecraftProfileTexture.Type texType, ResourceLocation texture) {
                TextureUtils.textures.get(texType).put(TextureSendPacket.this.profile.getName(), texture);
            }
        };
    }
}

