/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentMenuStuff;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.FuzzyMode;
import vswe.stevesfactory.components.ItemSetting;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.TextBoxNumber;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;

public class ComponentMenuItem
extends ComponentMenuStuff {
    private static final int DMG_VAL_TEXT_X = 15;
    private static final int DMG_VAL_TEXT_Y = 55;
    private static final int ARROW_SRC_X = 18;
    private static final int ARROW_SRC_Y = 20;
    private static final int ARROW_WIDTH = 6;
    private static final int ARROW_HEIGHT = 10;
    private static final int ARROW_X_LEFT = 5;
    private static final int ARROW_X_RIGHT = 109;
    private static final int ARROW_Y = 37;
    private static final int ARROW_TEXT_Y = 40;
    private TextBoxNumber damageValueTextBox;
    private TextBoxNumber amountTextBox;

    protected ComponentMenuItem(FlowComponent parent, Class<? extends Setting> settingClass) {
        super(parent, settingClass);
        if (((Setting)this.settings.get(0)).isAmountSpecific()) {
            this.amountTextBox = new TextBoxNumber(80, 24, 3, true){

                @Override
                public boolean isVisible() {
                    return ComponentMenuItem.this.selectedSetting.isLimitedByAmount();
                }

                @Override
                public void onNumberChanged() {
                    ComponentMenuItem.this.selectedSetting.setAmount(this.getNumber());
                    ComponentMenuItem.this.writeServerData(ComponentMenuStuff.DataTypeHeader.AMOUNT);
                }
            };
            this.numberTextBoxes.addTextBox(this.amountTextBox);
        }
        this.damageValueTextBox = new TextBoxNumber(70, 52, 5, true){

            @Override
            public boolean isVisible() {
                return ComponentMenuItem.this.getSelectedSetting().canChangeMetaData() && ComponentMenuItem.this.getSelectedSetting().getFuzzyMode().requiresMetaData();
            }

            @Override
            public void onNumberChanged() {
                ComponentMenuItem.this.getSelectedSetting().getItem().func_77964_b(this.getNumber());
                ComponentMenuItem.this.writeServerData(ComponentMenuStuff.DataTypeHeader.META);
            }
        };
        this.numberTextBoxes.addTextBox(this.damageValueTextBox);
    }

    public ComponentMenuItem(FlowComponent parent) {
        this(parent, ItemSetting.class);
    }

    protected ItemSetting getSelectedSetting() {
        return (ItemSetting)this.selectedSetting;
    }

    @Override
    public String getName() {
        return Localization.ITEM_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawInfoMenuContent(GuiManager gui, int mX, int mY) {
        if (this.damageValueTextBox.isVisible()) {
            gui.drawString(Localization.DAMAGE_VALUE.toString(), 15, 55, 0.7f, 0x404040);
        }
        for (int i = 0; i < 2; ++i) {
            int x = i == 0 ? 5 : 109;
            int y = 37;
            int srcXArrow = i;
            int srcYArrow = CollisionHelper.inBounds(x, y, 6, 10, mX, mY) ? 1 : 0;
            gui.drawTexture(x, y, 18 + srcXArrow * 6, 20 + srcYArrow * 10, 6, 10);
        }
        gui.drawCenteredString(this.getSelectedSetting().getFuzzyMode().toString(), 5, 40, 0.7f, 110, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawResultObject(GuiManager gui, Object obj, int x, int y) {
        gui.drawItemStack((ItemStack)obj, x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawSettingObject(GuiManager gui, Setting setting, int x, int y) {
        this.drawResultObject(gui, ((ItemSetting)setting).getItem(), x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected List<String> getResultObjectMouseOver(Object o) {
        return ComponentMenuItem.getToolTip((ItemStack)o);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected List<String> getSettingObjectMouseOver(Setting setting) {
        return this.getResultObjectMouseOver(((ItemSetting)setting).getItem());
    }

    @Override
    protected void updateTextBoxes() {
        if (this.amountTextBox != null) {
            this.amountTextBox.setNumber(this.selectedSetting.getAmount());
        }
        this.damageValueTextBox.setNumber(this.getSelectedSetting().getItem().func_77960_j());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        super.refreshData(container, newData);
        for (int i = 0; i < this.settings.size(); ++i) {
            ItemSetting setting = (ItemSetting)this.settings.get(i);
            ItemSetting newSetting = (ItemSetting)((ComponentMenuStuff)newData).settings.get(i);
            if (newSetting.getFuzzyMode() != setting.getFuzzyMode()) {
                setting.setFuzzyMode(newSetting.getFuzzyMode());
                this.writeClientData(container, ComponentMenuStuff.DataTypeHeader.USE_FUZZY, setting);
            }
            if (!newSetting.isValid() || !setting.isValid() || newSetting.getItem().func_77960_j() == setting.getItem().func_77960_j()) continue;
            setting.getItem().func_77964_b(newSetting.getItem().func_77960_j());
            this.writeClientData(container, ComponentMenuStuff.DataTypeHeader.META, setting);
        }
    }

    @Override
    protected DataBitHelper getAmountBitLength() {
        return DataBitHelper.MENU_ITEM_AMOUNT;
    }

    @Override
    protected void readSpecificHeaderData(DataReader dr, ComponentMenuStuff.DataTypeHeader header, Setting setting) {
        ItemSetting itemSetting = (ItemSetting)setting;
        switch (header) {
            case SET_ITEM: {
                int id = dr.readData(DataBitHelper.MENU_ITEM_ID);
                int dmg = dr.readData(DataBitHelper.MENU_ITEM_META);
                itemSetting.setItem(new ItemStack(Item.func_150899_d((int)id), 1, dmg));
                itemSetting.getItem().func_77982_d(dr.readNBT());
                if (!this.isEditing()) break;
                this.updateTextBoxes();
                break;
            }
            case USE_FUZZY: {
                itemSetting.setFuzzyMode(FuzzyMode.values()[dr.readData(DataBitHelper.FUZZY_MODE)]);
                break;
            }
            case META: {
                if (!setting.isValid()) break;
                itemSetting.getItem().func_77964_b(dr.readData(DataBitHelper.MENU_ITEM_META));
                if (!this.isEditing()) break;
                this.damageValueTextBox.setNumber(itemSetting.getItem().func_77960_j());
            }
        }
    }

    @Override
    protected void writeSpecificHeaderData(DataWriter dw, ComponentMenuStuff.DataTypeHeader header, Setting setting) {
        ItemSetting itemSetting = (ItemSetting)setting;
        switch (header) {
            case SET_ITEM: {
                dw.writeData(Item.func_150891_b((Item)itemSetting.getItem().func_77973_b()), DataBitHelper.MENU_ITEM_ID);
                dw.writeData(itemSetting.getItem().func_77960_j(), DataBitHelper.MENU_ITEM_META);
                dw.writeNBT(itemSetting.getItem().func_77978_p());
                break;
            }
            case USE_FUZZY: {
                dw.writeData(itemSetting.getFuzzyMode().ordinal(), DataBitHelper.FUZZY_MODE);
                break;
            }
            case META: {
                dw.writeData(itemSetting.getItem().func_77960_j(), DataBitHelper.MENU_ITEM_META);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected List updateSearch(String search, boolean showAll) {
        ArrayList<ItemStack> ret;
        block8: {
            block7: {
                ret = new ArrayList<ItemStack>();
                if (!search.equals(".inv")) break block7;
                InventoryPlayer inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
                int itemLength = inventory.func_70302_i_();
                for (int i = 0; i < itemLength; ++i) {
                    ItemStack item = inventory.func_70301_a(i);
                    if (item == null) continue;
                    item = item.func_77946_l();
                    item.field_77994_a = 1;
                    boolean exists = false;
                    for (Object e : ret) {
                        if (!ItemStack.func_77989_b((ItemStack)item, (ItemStack)((ItemStack)e))) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    ret.add(item);
                }
                break block8;
            }
            for (Item item : Item.field_150901_e) {
                if (item == null || item.func_77640_w() == null) continue;
                item.func_150895_a(item, null, ret);
            }
            if (showAll) break block8;
            Iterator itemIterator = ret.iterator();
            while (itemIterator.hasNext()) {
                List description;
                ItemStack itemStack = (ItemStack)itemIterator.next();
                try {
                    description = itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                }
                catch (Throwable ex) {
                    itemIterator.remove();
                    continue;
                }
                Iterator descriptionIterator = description.iterator();
                boolean foundSequence = false;
                while (descriptionIterator.hasNext()) {
                    String string = ((String)descriptionIterator.next()).toLowerCase();
                    if (!string.contains(search)) continue;
                    foundSequence = true;
                    break;
                }
                if (foundSequence) continue;
                itemIterator.remove();
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getToolTip(ItemStack itemStack) {
        try {
            return itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        catch (Exception ex) {
            if (itemStack.func_77960_j() == 0) {
                return new ArrayList<String>();
            }
            ItemStack newItem = itemStack.func_77946_l();
            newItem.func_77964_b(0);
            return ComponentMenuItem.getToolTip(newItem);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String getDisplayName(ItemStack itemStack) {
        try {
            return itemStack.func_82833_r();
        }
        catch (Exception ex) {
            if (itemStack.func_77960_j() == 0) {
                return "";
            }
            ItemStack newItem = itemStack.func_77946_l();
            newItem.func_77964_b(0);
            return ComponentMenuItem.getDisplayName(newItem);
        }
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        super.onClick(mX, mY, button);
        if (this.isEditing()) {
            for (int i = -1; i <= 1; i += 2) {
                int y;
                int x = i == 1 ? 109 : 5;
                if (!CollisionHelper.inBounds(x, y = 37, 6, 10, mX, mY)) continue;
                int id = this.getSelectedSetting().getFuzzyMode().ordinal();
                if ((id += i) < 0) {
                    id = FuzzyMode.values().length - 1;
                } else if (id == FuzzyMode.values().length) {
                    id = 0;
                }
                this.getSelectedSetting().setFuzzyMode(FuzzyMode.values()[id]);
                this.writeServerData(ComponentMenuStuff.DataTypeHeader.USE_FUZZY);
                break;
            }
        }
    }
}

