/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.renderers.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import shedar.mods.ic2.nuclearcontrol.panel.Screen;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAdvancedInfoPanel;

@SideOnly(value=Side.CLIENT)
public class ModelInfoPanel {
    private static final String TEXTURE_FILE = "nuclearcontrol:textures/blocks/infoPanel/panelAdvancedSide.png";
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("nuclearcontrol:textures/blocks/infoPanel/panelAdvancedSide.png");
    private double[] coordinates = new double[24];

    private void assignWithRotation(int rotation, int offset, int sign, int tl, int tr, int br, int bl, double dtl, double dtr, double dbr, double dbl) {
        switch (rotation) {
            case 0: {
                int n = tl * 3 + offset;
                this.coordinates[n] = this.coordinates[n] + (double)sign * dtl;
                int n2 = tr * 3 + offset;
                this.coordinates[n2] = this.coordinates[n2] + (double)sign * dtr;
                int n3 = br * 3 + offset;
                this.coordinates[n3] = this.coordinates[n3] + (double)sign * dbr;
                int n4 = bl * 3 + offset;
                this.coordinates[n4] = this.coordinates[n4] + (double)sign * dbl;
                break;
            }
            case 1: {
                int n = tl * 3 + offset;
                this.coordinates[n] = this.coordinates[n] + (double)sign * dbl;
                int n5 = tr * 3 + offset;
                this.coordinates[n5] = this.coordinates[n5] + (double)sign * dtl;
                int n6 = br * 3 + offset;
                this.coordinates[n6] = this.coordinates[n6] + (double)sign * dtr;
                int n7 = bl * 3 + offset;
                this.coordinates[n7] = this.coordinates[n7] + (double)sign * dbr;
                break;
            }
            case 2: {
                int n = tl * 3 + offset;
                this.coordinates[n] = this.coordinates[n] + (double)sign * dtr;
                int n8 = tr * 3 + offset;
                this.coordinates[n8] = this.coordinates[n8] + (double)sign * dbr;
                int n9 = br * 3 + offset;
                this.coordinates[n9] = this.coordinates[n9] + (double)sign * dbl;
                int n10 = bl * 3 + offset;
                this.coordinates[n10] = this.coordinates[n10] + (double)sign * dtl;
                break;
            }
            case 3: {
                int n = tl * 3 + offset;
                this.coordinates[n] = this.coordinates[n] + (double)sign * dbr;
                int n11 = tr * 3 + offset;
                this.coordinates[n11] = this.coordinates[n11] + (double)sign * dbl;
                int n12 = br * 3 + offset;
                this.coordinates[n12] = this.coordinates[n12] + (double)sign * dtl;
                int n13 = bl * 3 + offset;
                this.coordinates[n13] = this.coordinates[n13] + (double)sign * dtr;
                break;
            }
        }
    }

    public double[] getDeltas(TileEntityAdvancedInfoPanel panel, Screen screen) {
        double thickness;
        boolean isTopBottom = panel.rotateVert != 0;
        boolean isLeftRight = panel.rotateHor != 0;
        double dTopLeft = 0.0;
        double dTopRight = 0.0;
        double dBottomLeft = 0.0;
        double dBottomRight = 0.0;
        int height = screen.getHeight(panel);
        int width = screen.getWidth(panel);
        double maxDelta = 0.0;
        if (isTopBottom) {
            if (panel.rotateVert > 0) {
                dBottomRight = dBottomLeft = (double)height * Math.tan(Math.PI * (double)panel.rotateVert / 180.0);
                maxDelta = dBottomLeft;
            } else {
                maxDelta = dTopRight = (dTopLeft = (double)height * Math.tan(Math.PI * (double)(-panel.rotateVert) / 180.0));
            }
        }
        if (isLeftRight) {
            if (panel.rotateHor > 0) {
                maxDelta = dTopRight = (dBottomRight = (double)width * Math.tan(Math.PI * (double)panel.rotateHor / 180.0));
            } else {
                dTopLeft = dBottomLeft = (double)width * Math.tan(Math.PI * (double)(-panel.rotateHor) / 180.0);
                maxDelta = dBottomLeft;
            }
        }
        if (isTopBottom && isLeftRight) {
            maxDelta = dTopLeft == 0.0 ? (dBottomRight = dBottomLeft + dTopRight) : (dTopRight == 0.0 ? (dBottomLeft = dTopLeft + dBottomRight) : (dBottomLeft == 0.0 ? (dTopRight = dTopLeft + dBottomRight) : (dTopLeft = dBottomLeft + dTopRight)));
        }
        if (maxDelta > (thickness = (double)panel.thickness / 16.0)) {
            double scale = thickness / maxDelta;
            dTopLeft = scale * dTopLeft;
            dTopRight = scale * dTopRight;
            dBottomLeft = scale * dBottomLeft;
            dBottomRight = scale * dBottomRight;
        }
        double[] res = new double[]{dTopLeft, dTopRight, dBottomLeft, dBottomRight};
        return res;
    }

    private void addSlopes(TileEntityAdvancedInfoPanel panel, Screen screen, double[] deltas) {
        double dTopLeft = deltas[0];
        double dTopRight = deltas[1];
        double dBottomLeft = deltas[2];
        double dBottomRight = deltas[3];
        short facing = panel.facing;
        int rotation = panel.getRotation();
        switch (facing) {
            case 0: {
                this.assignWithRotation(rotation, 1, -1, 4, 7, 6, 5, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 1: {
                this.assignWithRotation(rotation, 1, 1, 3, 0, 1, 2, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 2: {
                this.assignWithRotation(rotation, 2, -1, 5, 6, 2, 1, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 3: {
                this.assignWithRotation(rotation, 2, 1, 7, 4, 0, 3, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 4: {
                this.assignWithRotation(rotation, 0, -1, 6, 7, 3, 2, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 5: {
                this.assignWithRotation(rotation, 0, 1, 4, 5, 1, 0, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
            }
        }
    }

    private void initCoordinates(Block block, Screen screen) {
        double blockMinX = block.func_149704_x();
        double blockMinY = block.func_149665_z();
        double blockMinZ = block.func_149706_B();
        double blockMaxX = block.func_149753_y();
        double blockMaxY = block.func_149669_A();
        double blockMaxZ = block.func_149693_C();
        this.coordinates[0] = (double)screen.minX + blockMinX;
        this.coordinates[1] = (double)screen.minY + blockMinY;
        this.coordinates[2] = (double)screen.minZ + blockMinZ;
        this.coordinates[3] = (double)screen.minX + blockMinX;
        this.coordinates[4] = (double)screen.minY + blockMinY;
        this.coordinates[5] = (double)screen.maxZ + blockMaxZ;
        this.coordinates[6] = (double)screen.maxX + blockMaxX;
        this.coordinates[7] = (double)screen.minY + blockMinY;
        this.coordinates[8] = (double)screen.maxZ + blockMaxZ;
        this.coordinates[9] = (double)screen.maxX + blockMaxX;
        this.coordinates[10] = (double)screen.minY + blockMinY;
        this.coordinates[11] = (double)screen.minZ + blockMinZ;
        this.coordinates[12] = (double)screen.minX + blockMinX;
        this.coordinates[13] = (double)screen.maxY + blockMaxY;
        this.coordinates[14] = (double)screen.minZ + blockMinZ;
        this.coordinates[15] = (double)screen.minX + blockMinX;
        this.coordinates[16] = (double)screen.maxY + blockMaxY;
        this.coordinates[17] = (double)screen.maxZ + blockMaxZ;
        this.coordinates[18] = (double)screen.maxX + blockMaxX;
        this.coordinates[19] = (double)screen.maxY + blockMaxY;
        this.coordinates[20] = (double)screen.maxZ + blockMaxZ;
        this.coordinates[21] = (double)screen.maxX + blockMaxX;
        this.coordinates[22] = (double)screen.maxY + blockMaxY;
        this.coordinates[23] = (double)screen.minZ + blockMinZ;
    }

    private void addPoint(int point, double u, double v) {
        Tessellator.field_78398_a.func_78374_a(this.coordinates[point * 3], this.coordinates[point * 3 + 1], this.coordinates[point * 3 + 2], u, v);
    }

    private void drawFacing(int facing, int rotation, Screen screen, TileEntityAdvancedInfoPanel panel, Block block, Tessellator tess) {
        int point = 0;
        int pointR = 0;
        int pointB = 0;
        int pointRB = 0;
        int offsetH = 0;
        int offsetV = 0;
        int offsetD = 0;
        boolean ccw = false;
        switch (facing) {
            case 0: {
                tess.func_78375_b(0.0f, -1.0f, 0.0f);
                point = 3;
                pointR = 0;
                pointB = 2;
                pointRB = 1;
                offsetH = 0;
                offsetV = 2;
                offsetD = 1;
                ccw = true;
                break;
            }
            case 1: {
                tess.func_78375_b(0.0f, 1.0f, 0.0f);
                point = 4;
                pointR = 7;
                pointB = 5;
                pointRB = 6;
                offsetH = 0;
                offsetV = 2;
                offsetD = 1;
                break;
            }
            case 2: {
                tess.func_78375_b(0.0f, 0.0f, -1.0f);
                point = 7;
                pointR = 4;
                pointB = 3;
                pointRB = 0;
                offsetH = 0;
                offsetV = 1;
                offsetD = 2;
                ccw = rotation == 1 || rotation == 2;
                break;
            }
            case 3: {
                tess.func_78375_b(0.0f, 0.0f, 1.0f);
                point = 5;
                pointR = 6;
                pointB = 1;
                pointRB = 2;
                offsetH = 0;
                offsetV = 1;
                offsetD = 2;
                break;
            }
            case 4: {
                tess.func_78375_b(-1.0f, 0.0f, 0.0f);
                point = 4;
                pointR = 5;
                pointB = 0;
                pointRB = 1;
                offsetH = 2;
                offsetV = 1;
                offsetD = 0;
                break;
            }
            case 5: {
                tess.func_78375_b(1.0f, 0.0f, 0.0f);
                point = 6;
                pointR = 7;
                pointB = 2;
                pointRB = 3;
                offsetH = 2;
                offsetV = 1;
                offsetD = 0;
                ccw = rotation == 1 || rotation == 2;
            }
        }
        switch (rotation) {
            case 1: {
                int tmp = offsetH;
                offsetH = offsetV;
                offsetV = tmp;
                pointB = point;
                point = pointR;
                pointR = pointRB;
                break;
            }
            case 2: {
                int tmp = offsetH;
                offsetH = offsetV;
                offsetV = tmp;
                pointR = point;
                point = pointB;
                pointB = pointRB;
                break;
            }
            case 3: {
                point = pointRB;
                int tmp = pointR;
                pointR = pointB;
                pointB = tmp;
            }
        }
        int stepsHor = screen.getWidth(panel);
        int stepsVert = screen.getHeight(panel);
        double dh = (this.coordinates[pointR * 3 + offsetH] - this.coordinates[point * 3 + offsetH]) / (double)stepsHor;
        double dv = (this.coordinates[pointB * 3 + offsetV] - this.coordinates[point * 3 + offsetV]) / (double)stepsVert;
        double ddh = (this.coordinates[pointR * 3 + offsetD] - this.coordinates[point * 3 + offsetD]) / (double)stepsHor;
        double ddv = (this.coordinates[pointB * 3 + offsetD] - this.coordinates[point * 3 + offsetD]) / (double)stepsVert;
        double[] base = new double[]{this.coordinates[point * 3], this.coordinates[point * 3 + 1], this.coordinates[point * 3 + 2]};
        double[] midpoint = new double[3];
        for (int sh = 0; sh < stepsHor; ++sh) {
            for (int sv = 0; sv < stepsVert; ++sv) {
                double[] p = (double[])base.clone();
                int n = offsetH;
                p[n] = p[n] + dh * (double)sh;
                int n2 = offsetV;
                p[n2] = p[n2] + dv * (double)sv;
                int n3 = offsetD;
                p[n3] = p[n3] + (ddh * (double)sh + ddv * (double)sv);
                midpoint[offsetH] = p[offsetH] + dh / 2.0;
                midpoint[offsetV] = p[offsetV] + dv / 2.0;
                midpoint[offsetD] = p[offsetD] + (ddh + ddv) / 2.0;
                IIcon texture = block.func_149673_e((IBlockAccess)panel.func_145831_w(), (int)Math.floor(midpoint[0]), (int)Math.floor(midpoint[1]), (int)Math.floor(midpoint[2]), facing);
                double u1 = texture.func_94209_e();
                double u2 = texture.func_94212_f();
                double v1 = texture.func_94206_g();
                double v2 = texture.func_94210_h();
                if (ccw) {
                    double tu = u1;
                    u1 = u2;
                    u2 = tu;
                }
                tess.func_78374_a(p[0], p[1], p[2], u1, v1);
                int n4 = offsetV;
                p[n4] = p[n4] + dv;
                int n5 = offsetD;
                p[n5] = p[n5] + ddv;
                tess.func_78374_a(p[0], p[1], p[2], u1, v2);
                int n6 = offsetH;
                p[n6] = p[n6] + dh;
                int n7 = offsetD;
                p[n7] = p[n7] + ddh;
                tess.func_78374_a(p[0], p[1], p[2], u2, v2);
                int n8 = offsetV;
                p[n8] = p[n8] - dv;
                int n9 = offsetD;
                p[n9] = p[n9] - ddv;
                tess.func_78374_a(p[0], p[1], p[2], u2, v1);
            }
        }
    }

    public void renderScreen(Block block, TileEntityAdvancedInfoPanel panel, double x, double y, double z, RenderBlocks renderer) {
        Screen screen = panel.getScreen();
        if (screen == null) {
            return;
        }
        this.initCoordinates(block, screen);
        double[] deltas = this.getDeltas(panel, screen);
        this.addSlopes(panel, screen, deltas);
        short facing = panel.getFacing();
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(block.func_149677_c((IBlockAccess)panel.func_145831_w(), panel.field_145851_c, panel.field_145848_d, panel.field_145849_e));
        tess.func_78386_a(0.5f, 0.5f, 0.5f);
        this.drawFacing(facing, panel.getRotation(), screen, panel, block, tess);
        tess.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        renderer.field_147877_p.field_71446_o.func_110577_a(TEXTURE_LOCATION);
        Tessellator.field_78398_a.func_78380_c(block.func_149677_c((IBlockAccess)panel.func_145831_w(), panel.field_145851_c, panel.field_145848_d, panel.field_145849_e));
        Tessellator.field_78398_a.func_78386_a(0.5f, 0.5f, 0.5f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int dx = screen.getDx() + 1;
        int dy = screen.getDy() + 1;
        int dz = screen.getDz() + 1;
        if (facing != 0) {
            Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
            this.addPoint(0, 0.0, 0.0);
            this.addPoint(3, dx, 0.0);
            this.addPoint(2, dx, dz);
            this.addPoint(1, 0.0, dz);
        }
        if (facing != 1) {
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            this.addPoint(4, 0.0, 0.0);
            this.addPoint(5, dz, 0.0);
            this.addPoint(6, dz, dx);
            this.addPoint(7, 0.0, dx);
        }
        if (facing != 2) {
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            this.addPoint(0, 0.0, 0.0);
            this.addPoint(4, dy, 0.0);
            this.addPoint(7, dy, dx);
            this.addPoint(3, 0.0, dx);
        }
        if (facing != 3) {
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
            this.addPoint(6, 0.0, 0.0);
            this.addPoint(5, dx, 0.0);
            this.addPoint(1, dx, dy);
            this.addPoint(2, 0.0, dy);
        }
        if (facing != 4) {
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            this.addPoint(5, 0.0, 0.0);
            this.addPoint(4, dz, 0.0);
            this.addPoint(0, dz, dy);
            this.addPoint(1, 0.0, dy);
        }
        if (facing != 5) {
            Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
            this.addPoint(2, 0.0, 0.0);
            this.addPoint(3, dz, 0.0);
            this.addPoint(7, dz, dy);
            this.addPoint(6, 0.0, dy);
        }
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        renderer.field_147877_p.field_71446_o.func_110577_a(TEXTURE_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator.field_78398_a.func_78386_a(0.5f, 0.5f, 0.5f);
        renderer.field_147877_p.field_71446_o.func_110577_a(TextureMap.field_110575_b);
    }
}

