/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world;

import ftb.utils.mod.FTBU;
import ftb.utils.world.LMPlayerServer;
import java.util.List;
import latmod.lib.LMStringUtils;
import latmod.lib.LMUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class LMPlayerStats {
    public int deaths;
    public long firstJoined;
    public long lastSeen;
    public long timePlayed;

    public void refresh(LMPlayerServer player, boolean force) {
        StatisticsFile file = player.getStatFile(force);
        if (file == null) {
            return;
        }
        long ms = LMUtils.millis();
        this.timePlayed = (long)file.func_77444_a(StatList.field_75948_k) * 50L;
        this.deaths = file.func_77444_a(StatList.field_75960_y);
        this.lastSeen = ms;
        if (this.firstJoined <= 0L) {
            this.firstJoined = this.lastSeen;
        }
    }

    public void getInfo(LMPlayerServer owner, List<IChatComponent> info, long ms) {
        if (this.lastSeen > 0L && !owner.isOnline()) {
            info.add(FTBU.mod.chatComponent("label.last_seen", new Object[]{LMStringUtils.getTimeString((long)(ms - this.lastSeen))}));
        }
        if (this.firstJoined > 0L) {
            info.add(FTBU.mod.chatComponent("label.joined", new Object[]{LMStringUtils.getTimeString((long)(ms - this.firstJoined))}));
        }
        if (this.deaths > 0) {
            info.add(FTBU.mod.chatComponent("label.deaths", new Object[]{String.valueOf(this.deaths)}));
        }
        if (this.timePlayed > 0L) {
            info.add(new ChatComponentTranslation("stat.playOneMinute", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(": " + LMStringUtils.getTimeString((long)this.timePlayed))));
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.deaths = tag.func_74762_e("Deaths");
        this.lastSeen = tag.func_74763_f("LastSeen");
        this.firstJoined = tag.func_74763_f("Joined");
        this.timePlayed = tag.func_74763_f("TimePlayed");
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("Deaths", this.deaths);
        tag.func_74772_a("LastSeen", this.lastSeen);
        tag.func_74772_a("Joined", this.firstJoined);
        tag.func_74772_a("TimePlayed", this.timePlayed);
    }

    public double getDeathsPerHour() {
        if (this.deaths == 0 || this.timePlayed == 0L) {
            return 0.0;
        }
        return (double)this.deaths / ((double)this.timePlayed / 3600000.0);
    }

    public long getLastSeen(LMPlayerServer p) {
        return p.isOnline() ? LMUtils.millis() : this.lastSeen;
    }

    public double getLastSeenDeltaInHours(LMPlayerServer p) {
        if (p.isOnline()) {
            return 0.0;
        }
        return (double)(LMUtils.millis() - this.getLastSeen(p)) / 3600000.0;
    }
}

