/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.varia.BlockTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.relay.GuiRelay;
import mcjty.rftools.blocks.relay.RelayTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.redstone.IRedstoneConnectable", modid="EnderIO")})
public class RelayBlock
extends GenericRFToolsBlock
implements IRedstoneConnectable {
    private IIcon[] icons = new IIcon[6];
    private IIcon iconFrontOff;

    public RelayBlock() {
        super(Material.field_151573_f, RelayTileEntity.class, false);
        this.func_149663_c("relayBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    public int getGuiID() {
        return RFTools.GUI_RELAY;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        RelayTileEntity relayTileEntity = (RelayTileEntity)tileEntity;
        return new GuiRelay(relayTileEntity, (Container)new EmptyContainer(entityPlayer));
    }

    public String getIdentifyingIconName() {
        return "machineRelay_on";
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstone(world, x, y, z);
    }

    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconFrontOff = iconRegister.func_94245_a("rftools:machineRelay");
        this.icons[ForgeDirection.DOWN.ordinal()] = iconRegister.func_94245_a("rftools:machineRelayD");
        this.icons[ForgeDirection.UP.ordinal()] = iconRegister.func_94245_a("rftools:machineRelayU");
        this.icons[ForgeDirection.NORTH.ordinal()] = iconRegister.func_94245_a("rftools:machineRelayN");
        this.icons[ForgeDirection.SOUTH.ordinal()] = null;
        this.icons[ForgeDirection.WEST.ordinal()] = iconRegister.func_94245_a("rftools:machineRelayW");
        this.icons[ForgeDirection.EAST.ordinal()] = iconRegister.func_94245_a("rftools:machineRelayE");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This device can (based on a redstone signal) limit");
            list.add(EnumChatFormatting.WHITE + "the amount of RF that can go through this. Using this");
            list.add(EnumChatFormatting.WHITE + "you can throttle down (or even disable) a number of");
            list.add(EnumChatFormatting.WHITE + "machines in case power is low.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int meta = blockAccess.func_72805_g(x, y, z);
        ForgeDirection direction = BlockTools.reorient((ForgeDirection)ForgeDirection.values()[side], (int)meta);
        if (direction == ForgeDirection.SOUTH) {
            return this.getIconInd(blockAccess, x, y, z, meta);
        }
        return this.icons[direction.ordinal()];
    }

    public IIcon getIconInd(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        boolean rs = BlockTools.getRedstoneSignal((int)meta);
        if (rs) {
            return this.iconInd;
        }
        return this.iconFrontOff;
    }
}

