/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import forestry.api.arboriculture.ITree;

public class WorldGenFir {

    public static class BalsamFir
    extends WorldGenTree {
        public BalsamFir(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = 1.0f;
            float width = (float)this.height / this.randBetween(2.0f, 2.5f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class SilverFir
    extends WorldGenTree {
        public SilverFir(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.5f, 3.0f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(7, 3);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class DouglasFir
    extends WorldGenTree {
        public DouglasFir(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 1;
            float patchyBottom = this.height / 2;
            float bottom = this.randBetween(3, 4);
            float width = (float)this.height * this.randBetween(0.35f, 0.4f);
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.8f * width, 1, this.leaf, false);
            this.bushiness = 0.1f;
            while (leafSpawn > patchyBottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.9f, 1.1f) * width, 1, this.leaf, false);
            }
            this.bushiness = 0.5f;
            while (leafSpawn > bottom) {
                float f4 = leafSpawn;
                leafSpawn = f4 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), this.randBetween(0.7f, 1.0f) * width, 1, this.leaf, false);
            }
            float f5 = leafSpawn;
            leafSpawn = f5 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f5, 0.0f), 0.7f * width, 1, this.leaf, false);
            float f6 = leafSpawn;
            leafSpawn = f6 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f6, 0.0f), 0.3f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(7, 3);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }
}

