/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Template;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.builders.patterns.PatternParameterCenter;
import buildcraft.core.builders.patterns.PatternParameterYDir;
import net.minecraft.world.World;

public class PatternPyramid
extends FillerPattern {
    private static final int[] MODIFIERS = new int[]{257, 4353, 4097, 273, 4369, 4113, 272, 4368, 4112};

    public PatternPyramid() {
        super("pyramid");
    }

    @Override
    public int maxParameters() {
        return 2;
    }

    @Override
    public int minParameters() {
        return 2;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return index == 1 ? new PatternParameterCenter(4) : new PatternParameterYDir(true);
    }

    @Override
    public Template getTemplate(Box box, World world, IStatementParameter[] parameters) {
        int xMin = (int)box.pMin().x;
        int yMin = (int)box.pMin().y;
        int zMin = (int)box.pMin().z;
        int xMax = (int)box.pMax().x;
        int yMax = (int)box.pMax().y;
        int zMax = (int)box.pMax().z;
        Template bpt = new Template(xMax - xMin + 1, yMax - yMin + 1, zMax - zMin + 1);
        int[] modifiers = new int[4];
        int stepY = parameters.length >= 1 && parameters[0] != null && !((PatternParameterYDir)parameters[0]).up ? -1 : 1;
        int center = 4;
        if (parameters.length >= 2 && parameters[1] != null) {
            center = ((PatternParameterCenter)parameters[1]).getDirection();
        }
        modifiers[0] = MODIFIERS[center] >> 12 & 1;
        modifiers[1] = MODIFIERS[center] >> 8 & 1;
        modifiers[2] = MODIFIERS[center] >> 4 & 1;
        modifiers[3] = MODIFIERS[center] & 1;
        int x1 = xMin;
        int x2 = xMax;
        int z1 = zMin;
        int z2 = zMax;
        for (int height = stepY == 1 ? yMin : yMax; height >= yMin && height <= yMax; height += stepY) {
            for (int x = x1; x <= x2; ++x) {
                for (int z = z1; z <= z2; ++z) {
                    bpt.put(x - xMin, height - yMin, z - zMin, new SchematicMask(true));
                }
            }
            if ((x1 += modifiers[0]) <= (x2 -= modifiers[1]) && (z1 += modifiers[2]) <= (z2 -= modifiers[3])) continue;
            break;
        }
        return bpt;
    }
}

