/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.entities;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.common.entities.WirelessGolemHandler;
import thaumicenergistics.common.grid.WirelessAELink;
import thaumicenergistics.common.integration.tc.GolemUpgradeTypes;

public abstract class AIAENetworkGolem
extends EntityAIBase {
    private static final int NETWORK_COOLDOWN = 20;
    private static final int[] FLUID_RATES = new int[]{100, 250, 500};
    private static final int[] ITEM_RATES = new int[]{8, 24, 32};
    private static final int[] ESS_RATES = new int[]{4, 12, 16};
    private int actionTimer = 0;
    public final NetworkHandler network;
    protected final EntityGolemBase golem;

    public AIAENetworkGolem(EntityGolemBase golem, WirelessGolemHandler.WirelessServerData wsd) {
        this.golem = golem;
        int rateMult = golem.advanced ? 2 : 1;
        int orderUpgrades = this.golem.getUpgradeAmount((int)GolemUpgradeTypes.Order.upgradeID);
        if (orderUpgrades > 2) {
            orderUpgrades = 2;
        } else if (orderUpgrades < 0) {
            orderUpgrades = 0;
        }
        int maxItems = ITEM_RATES[orderUpgrades] * rateMult;
        int maxEssentia = ESS_RATES[orderUpgrades] * rateMult;
        int maxFluids = FLUID_RATES[orderUpgrades] * rateMult;
        this.network = new NetworkHandler(wsd, maxItems, maxFluids, maxEssentia);
    }

    private boolean cooledDown() {
        if (this.actionTimer > 0) {
            --this.actionTimer;
            return false;
        }
        return true;
    }

    private void restartNetworkCooldown() {
        this.actionTimer = 20;
    }

    protected abstract boolean needsNetworkNow();

    public final boolean func_75250_a() {
        if (this.cooledDown()) {
            this.restartNetworkCooldown();
            if (this.network.isConnected()) {
                return this.needsNetworkNow();
            }
        }
        return false;
    }

    public abstract void func_75246_d();

    protected class NetworkHandler
    extends WirelessAELink {
        private final int maxItemRate;
        private final int maxFluidRate;
        private final int maxEssentiaRate;
        public final WirelessGolemHandler.WirelessServerData wirelessStateData;

        public NetworkHandler(WirelessGolemHandler.WirelessServerData wsd, int maxItems, int maxFluids, int maxEssentia) {
            super(null, wsd.encryptionKey);
            this.maxItemRate = maxItems;
            this.maxFluidRate = maxFluids;
            this.maxEssentiaRate = maxEssentia;
            this.wirelessStateData = wsd;
            this.isConnected();
        }

        @Override
        protected int getUserPositionX() {
            return (int)AIAENetworkGolem.this.golem.field_70165_t;
        }

        @Override
        protected int getUserPositionY() {
            return (int)AIAENetworkGolem.this.golem.field_70163_u;
        }

        @Override
        protected int getUserPositionZ() {
            return (int)AIAENetworkGolem.this.golem.field_70161_v;
        }

        @Override
        protected World getUserWorld() {
            return AIAENetworkGolem.this.golem.field_70170_p;
        }

        @Override
        protected boolean hasPowerToCommunicate() {
            return true;
        }

        public void depositStack(ItemStack stack) {
            IMEMonitor<IAEItemStack> monitor = this.getItemInventory();
            if (monitor == null) {
                return;
            }
            IAEItemStack aeStack = AEApi.instance().storage().createItemStack(stack);
            int depositSize = Math.min(stack.field_77994_a, this.maxItemRate);
            aeStack.setStackSize((long)depositSize);
            IAEItemStack rejected = AEApi.instance().storage().poweredInsert((IEnergySource)this.getEnergyGrid(), monitor, aeStack, this.actionSource);
            if (rejected != null) {
                depositSize -= (int)rejected.getStackSize();
            }
            stack.field_77994_a -= depositSize;
        }

        public long extractEssentia(Aspect aspect, int amount, Actionable mode) {
            IMEEssentiaMonitor monitor = this.getEssentiaInventory();
            if (monitor == null) {
                return 0L;
            }
            return monitor.extractEssentia(aspect, Math.min(amount, this.maxEssentiaRate), mode, this.actionSource, mode == Actionable.MODULATE);
        }

        public FluidStack extractFluid(FluidStack target) {
            IMEMonitor<IAEFluidStack> monitor = this.getFluidInventory();
            if (monitor == null) {
                return null;
            }
            IEnergyGrid eGrid = this.getEnergyGrid();
            if (eGrid == null) {
                return null;
            }
            long requestSize = Math.min(target.amount, this.maxFluidRate);
            double pwrReq = requestSize / 100L;
            if (eGrid.extractAEPower(pwrReq, Actionable.SIMULATE, PowerMultiplier.CONFIG) < pwrReq) {
                return null;
            }
            IAEFluidStack aeRequest = AEApi.instance().storage().createFluidStack(target);
            aeRequest.setStackSize(requestSize);
            IAEFluidStack extracted = (IAEFluidStack)monitor.extractItems((IAEStack)aeRequest, Actionable.MODULATE, this.actionSource);
            if (extracted == null) {
                return null;
            }
            pwrReq = extracted.getStackSize() / 100L;
            eGrid.extractAEPower(pwrReq, Actionable.MODULATE, PowerMultiplier.CONFIG);
            return extracted.getFluidStack();
        }

        public ItemStack extractStack(ItemStack target) {
            IMEMonitor<IAEItemStack> monitor = this.getItemInventory();
            if (monitor == null) {
                return null;
            }
            IAEItemStack aeRequest = AEApi.instance().storage().createItemStack(target);
            aeRequest.setStackSize((long)Math.min(target.field_77994_a, this.maxItemRate));
            IAEItemStack extracted = AEApi.instance().storage().poweredExtraction((IEnergySource)this.getEnergyGrid(), monitor, aeRequest, this.actionSource);
            if (extracted == null) {
                return null;
            }
            return extracted.getItemStack();
        }

        public long insertEssentia(Aspect aspect, int amount) {
            IMEEssentiaMonitor monitor = this.getEssentiaInventory();
            if (monitor == null) {
                return 0L;
            }
            int amountToInject = Math.min(amount, this.maxEssentiaRate);
            long amountRejected = monitor.injectEssentia(aspect, amountToInject, Actionable.MODULATE, this.actionSource, true);
            return (long)amountToInject - amountRejected;
        }

        @Override
        public boolean isConnected() {
            this.wirelessStateData.isInRange = super.isConnected();
            return this.wirelessStateData.isInRange;
        }
    }
}

