/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.AEApi;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.ICraftingIssuerHost;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.container.ContainerEssentiaCellTerminalBase;
import thaumicenergistics.common.items.ItemCraftingAspect;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaCellTerminal;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaCellTerminal;
import thaumicenergistics.common.parts.PartEssentiaTerminal;
import thaumicenergistics.common.storage.AspectStackComparator;
import thaumicenergistics.common.utils.EffectiveSide;

public class ContainerEssentiaTerminal
extends ContainerEssentiaCellTerminalBase {
    @Nonnull
    private final PartEssentiaTerminal terminal;
    private final PlayerSource playerSource;

    public ContainerEssentiaTerminal(@Nonnull PartEssentiaTerminal terminal, EntityPlayer player) {
        super(player);
        this.terminal = terminal;
        this.playerSource = new PlayerSource(player, (IActionHost)this.terminal);
        if (EffectiveSide.isServerSide()) {
            terminal.addListener(this);
        } else {
            Packet_S_EssentiaCellTerminal.sendFullUpdateRequest(this.player);
        }
        this.bindToInventory(terminal.getInventory());
    }

    @Override
    protected BaseActionSource getActionSource() {
        return this.playerSource;
    }

    @Override
    protected IGrid getHostGrid() {
        try {
            return this.terminal.getGridBlock().getGrid();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Aspect getHostSelectedAspect() {
        return this.terminal.selectedAspect;
    }

    @Override
    protected IMEEssentiaMonitor getNewMonitor() {
        return this.terminal.getGridBlock().getEssentiaMonitor();
    }

    @Override
    protected void setHostSelectedAspect(Aspect aspect) {
        this.terminal.selectedAspect = aspect;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.terminal.isPartUseableByPlayer(player);
    }

    @Override
    public void doWork(int elapsedTicks) {
        this.transferEssentiaFromWorkSlots();
    }

    @Override
    public ICraftingIssuerHost getCraftingHost() {
        return this.terminal;
    }

    @Override
    public void onClientRequestAutoCraft(EntityPlayer player, Aspect aspect) {
        TileEntity te = this.terminal.getHostTile();
        ThEGuiHandler.launchGui(80, player, te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
        if (player.field_71070_bA instanceof ContainerCraftAmount) {
            ContainerCraftAmount cca = (ContainerCraftAmount)this.player.field_71070_bA;
            cca.setOpenContext(new ContainerOpenContext((Object)te));
            cca.getOpenContext().setWorld(te.func_145831_w());
            cca.getOpenContext().setX(te.field_145851_c);
            cca.getOpenContext().setY(te.field_145848_d);
            cca.getOpenContext().setZ(te.field_145849_e);
            cca.getOpenContext().setSide(this.terminal.getSide());
            IAEItemStack result = AEApi.instance().storage().createItemStack(ItemCraftingAspect.createStackForAspect(aspect, 1));
            cca.getCraftingItem().func_75215_d(result.getItemStack());
            cca.setItemToCraft(result);
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71137_h = false;
            }
            cca.func_75142_b();
        }
    }

    @Override
    public void onClientRequestFullUpdate() {
        this.onModeChanged(this.terminal.getSortingMode(), this.terminal.getViewMode());
        Packet_C_EssentiaCellTerminal.sendFullList(this.player, this.repo.getAll());
    }

    @Override
    public void onClientRequestSortModeChange(EntityPlayer player, boolean backwards) {
        this.terminal.onClientRequestSortingModeChange(backwards);
    }

    @Override
    public void onClientRequestViewModeChange(EntityPlayer player, boolean backwards) {
        this.terminal.onClientRequestViewModeChange(backwards);
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (EffectiveSide.isServerSide()) {
            this.terminal.removeListener(this);
        }
    }

    public void onModeChanged(AspectStackComparator.AspectStackComparatorMode sortingMode, ViewItems viewMode) {
        Packet_C_EssentiaCellTerminal.sendViewingModes(this.player, sortingMode, viewMode);
    }
}

