/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.api.capability;

import java.util.List;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class KitchenItemProvider
extends DefaultKitchenItemProvider {
    private IItemHandler itemHandler;
    private int[] usedStackSize;

    public KitchenItemProvider() {
    }

    public KitchenItemProvider(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
        this.usedStackSize = new int[itemHandler.getSlots()];
    }

    public void setItemHandler(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
        this.usedStackSize = new int[itemHandler.getSlots()];
    }

    @Override
    public void resetSimulation() {
        for (int i = 0; i < this.usedStackSize.length; ++i) {
            this.usedStackSize[i] = 0;
        }
    }

    @Override
    public int getSimulatedUseCount(int slot) {
        return this.usedStackSize[slot];
    }

    @Override
    public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(slot);
        if (itemStack.func_190916_E() - (simulate ? this.usedStackSize[slot] : 0) >= amount) {
            ItemStack result = this.itemHandler.extractItem(slot, amount, simulate);
            if (simulate && !result.func_190926_b()) {
                int n = slot;
                this.usedStackSize[n] = this.usedStackSize[n] + result.func_190916_E();
            }
            return result;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack returnItemStack(ItemStack itemStack) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)itemStack, (boolean)false);
    }

    @Override
    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }
}

