/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.block;

import edgarallen.soundmuffler.SuperSoundMuffler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntitySoundMuffler
extends TileEntity {
    private HashSet<ResourceLocation> muffledSounds = new HashSet();
    private boolean whiteListMode = true;
    private static final int[] ranges = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 32, 64, 128, 256};
    private static final int defaultRangeIndex = 7;
    private int rangeIndex = 7;

    public void onLoad() {
        SuperSoundMuffler.proxy.cacheMuffler(this);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound = this.writeNBT(compound);
        return compound;
    }

    public NBTTagCompound writeNBT(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (ResourceLocation sound : this.muffledSounds) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("sound", sound.toString());
            tagList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("sounds", (NBTBase)tagList);
        compound.func_74757_a("whiteList", this.whiteListMode);
        compound.func_74776_a("rangeIndex", (float)this.rangeIndex);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNBT(compound);
    }

    public void readNBT(NBTTagCompound compound) {
        this.muffledSounds.clear();
        this.whiteListMode = true;
        NBTTagList tagList = compound.func_150295_c("sounds", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound sound = tagList.func_150305_b(i);
            this.muffledSounds.add(new ResourceLocation(sound.func_74779_i("sound")));
        }
        this.whiteListMode = compound.func_74767_n("whiteList");
        this.rangeIndex = compound.func_74762_e("rangeIndex");
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        compound = this.writeNBT(compound);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    boolean isDefault() {
        return this.whiteListMode && this.muffledSounds.isEmpty() && this.rangeIndex == 7;
    }

    public void muffleSound(ResourceLocation sound) {
        this.muffledSounds.add(sound);
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 4);
    }

    public void unmuffleSound(ResourceLocation sound) {
        this.muffledSounds.remove(sound);
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 4);
    }

    public List<ResourceLocation> getMuffledSounds() {
        return new ArrayList<ResourceLocation>(this.muffledSounds);
    }

    public void toggleWhiteListMode() {
        this.whiteListMode = !this.whiteListMode;
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 4);
    }

    public boolean isWhiteList() {
        return this.whiteListMode;
    }

    public boolean shouldMuffleSound(ResourceLocation soundLocation) {
        if (this.isWhiteList()) {
            return !this.muffledSounds.contains(soundLocation);
        }
        return this.muffledSounds.contains(soundLocation);
    }

    public boolean shouldMuffleSound(ISound sound) {
        int range;
        double dist = this.func_145835_a(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
        return dist <= (double)((range = this.getRange()) * range + 1) && this.shouldMuffleSound(sound.func_147650_b());
    }

    public void setRange(int value) {
        this.rangeIndex = value;
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 4);
    }

    public int getRange() {
        return ranges[this.rangeIndex];
    }

    public static int getRange(int rangeIndex) {
        return ranges[rangeIndex];
    }

    public int getRangeIndex() {
        return this.rangeIndex;
    }

    public static int getDefaultRange() {
        return ranges[7];
    }

    public static int getDefaultRangeIndex() {
        return 7;
    }
}

