/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.block;

import edgarallen.soundmuffler.SuperSoundMuffler;
import edgarallen.soundmuffler.block.RenderTileSoundMuffler;
import edgarallen.soundmuffler.block.TileEntitySoundMuffler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSoundMuffler
extends BlockContainer {
    public static final String NAME = "sound_muffler";
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1, 0.1, 0.1, 0.9, 0.9, 0.9);

    public BlockSoundMuffler() {
        super(Material.field_151575_d);
        this.setRegistryName(NAME);
        this.func_149663_c(NAME);
        this.func_149711_c(0.1f);
        this.func_149752_b(10.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntitySoundMuffler && !te.func_145837_r()) {
            playerIn.openGui((Object)SuperSoundMuffler.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntitySoundMuffler) {
            TileEntitySoundMuffler tileEntity = (TileEntitySoundMuffler)te;
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("sounds")) {
                tileEntity.readNBT(stack.func_77978_p());
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public String getHarvestTool(@Nonnull IBlockState state) {
        return null;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntitySoundMuffler tileEntity;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack stack = new ItemStack((Block)this, 1);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntitySoundMuffler && !(tileEntity = (TileEntitySoundMuffler)te).isDefault()) {
            NBTTagCompound compound = tileEntity.writeNBT(new NBTTagCompound());
            stack.func_77982_d(compound);
        }
        list.add(stack);
        return list;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySoundMuffler();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            boolean showWhiteListTooltip = !compound.func_74764_b("whiteList") || compound.func_74767_n("whiteList");
            String key = showWhiteListTooltip ? "item.sound_muffler.tooltip.mode.white_list" : "item.sound_muffler.tooltip.mode.black_list";
            tooltip.add(I18n.func_135052_a((String)key, (Object[])new Object[0]));
            int rangeIndex = compound.func_74764_b("rangeIndex") ? compound.func_74762_e("rangeIndex") : TileEntitySoundMuffler.getDefaultRangeIndex();
            tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.range", (Object[])new Object[]{TileEntitySoundMuffler.getRange(rangeIndex)}));
            if (compound.func_74764_b("sounds")) {
                NBTTagList tagList = compound.func_150295_c("sounds", 10);
                int count = tagList.func_74745_c();
                tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sounds.count", (Object[])new Object[]{count}));
                if (GuiScreen.func_146272_n()) {
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound sound = tagList.func_150305_b(i);
                        tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sound", (Object[])new Object[]{sound.func_74779_i("sound")}));
                    }
                }
            } else {
                tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sounds.count", (Object[])new Object[]{0}));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.mode.white_list", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.range", (Object[])new Object[]{TileEntitySoundMuffler.getDefaultRange()}));
            tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sounds.count", (Object[])new Object[]{0}));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySoundMuffler.class, (TileEntitySpecialRenderer)new RenderTileSoundMuffler());
    }
}

