/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler;

import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.collect.EvictingQueue;
import edgarallen.soundmuffler.bauble.ItemSoundMufflerBauble;
import edgarallen.soundmuffler.block.BlockSoundMuffler;
import edgarallen.soundmuffler.block.TileEntitySoundMuffler;
import edgarallen.soundmuffler.compat.waila.SoundMufflerWailaDataProvider;
import edgarallen.soundmuffler.config.Config;
import edgarallen.soundmuffler.gui.GuiHandler;
import edgarallen.soundmuffler.network.ThePacketeer;
import edgarallen.soundmuffler.proxy.CommonProxy;
import java.util.Queue;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="supersoundmuffler", name="Super Sound Muffler", version="1.0.2.9", dependencies="after:baubles;after:theoneprobe;after:waila", acceptedMinecraftVersions="[1.12.1]")
public class SuperSoundMuffler {
    public static final String MOD_ID = "supersoundmuffler";
    public static final String NAME = "Super Sound Muffler";
    public static final String VERSION = "1.0.2.9";
    public static final String DEPENDENCIES = "after:baubles;after:theoneprobe;after:waila";
    @Mod.Instance(value="supersoundmuffler")
    public static SuperSoundMuffler instance;
    public static final Logger log;
    private boolean checkBaubleSlots = false;
    @SidedProxy(clientSide="edgarallen.soundmuffler.proxy.ClientProxy", serverSide="edgarallen.soundmuffler.proxy.CommonProxy")
    public static CommonProxy proxy;
    @GameRegistry.ObjectHolder(value="sound_muffler")
    public static BlockSoundMuffler blockSoundMuffler;
    @GameRegistry.ObjectHolder(value="sound_muffler_bauble")
    public static ItemSoundMufflerBauble itemSoundMufflerBauble;
    public Queue<ResourceLocation> recentSounds = EvictingQueue.create((int)16);
    public static int ticksInGame;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.readConfig(event.getSuggestedConfigurationFile());
        ThePacketeer.init();
        if (event.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        if (Loader.isModLoaded((String)"waila")) {
            SoundMufflerWailaDataProvider.register();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.checkBaubleSlots = Loader.isModLoaded((String)"baubles");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlaySound(PlaySoundEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            ISound sound = event.getSound();
            if (this.tryMuffleBauble(event, sound)) {
                return;
            }
            if (this.tryMuffleBlock(event, world, sound)) {
                return;
            }
            this.recentSounds.offer(sound.func_147650_b());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean tryMuffleBauble(PlaySoundEvent event, ISound sound) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            InventoryPlayer inventory = player.field_71071_by;
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                ItemStack stack = inventory.func_70301_a(slot);
                if (stack.func_190926_b() || stack.func_77973_b() != itemSoundMufflerBauble || !itemSoundMufflerBauble.shouldMuffleSound(stack, sound.func_147650_b())) continue;
                event.setResultSound(null);
                return true;
            }
            if (this.checkBaubleSlots) {
                IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, player.func_174811_aO());
                for (int slot = 0; slot < baubles.getSlots(); ++slot) {
                    ItemStack stack = baubles.getStackInSlot(slot);
                    if (stack.func_190926_b() || stack.func_77973_b() != itemSoundMufflerBauble || !itemSoundMufflerBauble.shouldMuffleSound(stack, sound.func_147650_b())) continue;
                    event.setResultSound(null);
                    return true;
                }
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean tryMuffleBlock(PlaySoundEvent event, WorldClient world, ISound sound) {
        Set<TileEntitySoundMuffler> mufflers = proxy.getTileEntities();
        for (TileEntitySoundMuffler tile : mufflers) {
            if (tile.func_145837_r() || !tile.shouldMuffleSound(sound)) continue;
            event.setResultSound(null);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        GuiScreen gui;
        if (!(event.phase != TickEvent.Phase.END || (gui = Minecraft.func_71410_x().field_71462_r) != null && gui.func_73868_f())) {
            ++ticksInGame;
        }
    }

    static {
        log = LogManager.getLogger((String)NAME);
        ticksInGame = 0;
    }
}

