/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.m_guide.json.objects;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.valkyrieofnight.vlib.lib.client.gui.elements.container.VLEleContBase;
import com.valkyrieofnight.vlib.lib.json.IJsonSerializer;
import com.valkyrieofnight.vlib.m_guide.client.elements.TileDataElement;
import com.valkyrieofnight.vlib.m_guide.json.objects.GuideObject;
import com.valkyrieofnight.vlib.m_guide.registry.TDPModSection;
import com.valkyrieofnight.vlib.m_guide.registry.TDPModSectionRegistry;
import com.valkyrieofnight.vlib.m_guide.registry.TileData;
import com.valkyrieofnight.vlib.m_guide.registry.TileDataProvider;
import java.lang.reflect.Type;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;

public class GOTileData
extends GuideObject {
    public static final GOTileData BLANK = new GOTileData();
    public String modID;
    public String tileID;
    public String dataID;
    public String mcStyleCodes;
    public int r;
    public int g;
    public int b;

    @Override
    public String getType() {
        return "tiledata";
    }

    @Override
    public void initElement(String baseAddress, VLEleContBase cont) {
        boolean in = false;
        TileData finalData = null;
        TDPModSection ms = TDPModSectionRegistry.getInstance().getModSection(this.modID);
        if (ms == null) {
            in = true;
        } else {
            TileDataProvider dp = ms.getProvider(this.tileID);
            if (dp == null) {
                in = true;
            } else {
                finalData = dp.getData(this.dataID);
            }
        }
        if (finalData == null) {
            finalData = TileData.BLANK;
        }
        TileDataElement e = new TileDataElement(baseAddress + cont.getTotalElements() + this.getType(), 0, 0, finalData);
        cont.addElement(e);
        e.setStyleCodes(this.getStyleCodes());
        e.setColor(this.r, this.g, this.b);
    }

    public String getStyleCodes() {
        if (StringUtils.func_151246_b((String)this.mcStyleCodes)) {
            return "";
        }
        String[] s = this.mcStyleCodes.split(",");
        String formats = "";
        for (String string : s) {
            TextFormatting tf = TextFormatting.func_96300_b((String)string);
            formats = formats + tf;
        }
        return formats;
    }

    public static class GOTileDataSerializer
    implements IJsonSerializer<GOTileData> {
        public JsonElement serialize(GOTileData src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject r = new JsonObject();
            r.addProperty("type", src.getType());
            r.addProperty("modid", src.modID);
            r.addProperty("tileid", src.tileID);
            r.addProperty("dataid", src.dataID);
            r.addProperty("mcstyles", src.mcStyleCodes);
            r.addProperty("r", (Number)src.r);
            r.addProperty("g", (Number)src.g);
            r.addProperty("b", (Number)src.b);
            return r;
        }

        public GOTileData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement cb;
            JsonElement cg;
            JsonElement cr;
            JsonElement sc;
            JsonElement ss;
            JsonElement sp;
            GOTileData r = new GOTileData();
            JsonObject jobj = json.getAsJsonObject();
            JsonElement mi = jobj.get("modid");
            if (mi != null) {
                r.modID = mi.getAsString();
            }
            if ((sp = jobj.get("tileid")) != null) {
                r.tileID = sp.getAsString();
            }
            if ((ss = jobj.get("dataid")) != null) {
                r.dataID = ss.getAsString();
            }
            if ((sc = jobj.get("mcstyles")) != null) {
                r.mcStyleCodes = sc.getAsString();
            }
            if ((cr = jobj.get("r")) != null) {
                r.r = cr.getAsInt();
            }
            if ((cg = jobj.get("g")) != null) {
                r.g = cg.getAsInt();
            }
            if ((cb = jobj.get("b")) != null) {
                r.b = cb.getAsInt();
            }
            return r;
        }
    }
}

