/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.m_guide.json.objects;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.valkyrieofnight.vlib.legacy.util.helpers.LanguageHelper;
import com.valkyrieofnight.vlib.lib.client.gui.elements.container.VLEleContBase;
import com.valkyrieofnight.vlib.lib.client.gui.elements.text.VLTextParagraph;
import com.valkyrieofnight.vlib.lib.json.IJsonSerializer;
import com.valkyrieofnight.vlib.m_guide.json.objects.GuideObject;
import java.lang.reflect.Type;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;

public class GOParagraph
extends GuideObject {
    public static final GOParagraph BLANK = new GOParagraph();
    public String mcStyleCodes;
    public String unlocalizedID;
    public int r;
    public int g;
    public int b;

    @Override
    public String getType() {
        return "paragraph";
    }

    public String toString() {
        String str = "{" + this.mcStyleCodes + ":" + this.unlocalizedID + ":" + this.r + "" + this.g + "" + this.b + "}";
        return str;
    }

    @Override
    public void initElement(String baseAddress, VLEleContBase cont) {
        VLTextParagraph e = new VLTextParagraph(baseAddress + "." + cont.getTotalElements() + this.getType(), 0, 0, LanguageHelper.toLoc(this.unlocalizedID), cont.getXSize() - 8);
        cont.addElement(e);
        e.setStyleCodes(this.getStyleCodes());
        e.setColor(this.r, this.g, this.b);
    }

    public String getStyleCodes() {
        if (StringUtils.func_151246_b((String)this.mcStyleCodes)) {
            return "";
        }
        String[] s = this.mcStyleCodes.split(",");
        String formats = "";
        for (String string : s) {
            TextFormatting tf = TextFormatting.func_96300_b((String)string);
            formats = formats + tf;
        }
        return formats;
    }

    public static class GOParagraphSerializer
    implements IJsonSerializer<GOParagraph> {
        public GOParagraph deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement cb;
            JsonElement cg;
            JsonElement cr;
            JsonElement uid;
            GOParagraph r = new GOParagraph();
            JsonObject jobj = json.getAsJsonObject();
            JsonElement sc = jobj.get("mcstyles");
            if (sc != null) {
                r.mcStyleCodes = sc.getAsString();
            }
            if ((uid = jobj.get("unlocalizedid")) != null) {
                r.unlocalizedID = uid.getAsString();
            }
            if ((cr = jobj.get("r")) != null) {
                r.r = cr.getAsInt();
            }
            if ((cg = jobj.get("g")) != null) {
                r.g = cg.getAsInt();
            }
            if ((cb = jobj.get("b")) != null) {
                r.b = cb.getAsInt();
            }
            return r;
        }

        public JsonElement serialize(GOParagraph src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject r = new JsonObject();
            r.addProperty("type", src.getType());
            r.addProperty("mcstyles", src.mcStyleCodes);
            r.addProperty("unlocalizedid", src.unlocalizedID);
            r.addProperty("r", (Number)src.r);
            r.addProperty("g", (Number)src.g);
            r.addProperty("b", (Number)src.b);
            return r;
        }
    }
}

