/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.tilemodule.energyu.fe.storage;

import com.valkyrieofnight.vlib.lib.tilemodule.energyu.fe.IFEConsumer;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.fe.IFEInternals;
import com.valkyrieofnight.vlib.lib.util.INBTHandler;
import net.minecraft.nbt.NBTTagCompound;

public class FEConsumer
implements IFEConsumer,
INBTHandler<FEConsumer>,
IFEInternals {
    protected int energy = 0;
    protected int capacity;
    protected int maxReceive;

    public FEConsumer(int capacity) {
        this(capacity, capacity);
    }

    public FEConsumer(int capacity, int maxReceive) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public FEConsumer readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("Energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    @Override
    public void iSetFEStored(int en) {
        this.energy = en;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
    }

    @Override
    public int iReceiveFE(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int iExtractFE(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getRoom() {
        return this.capacity - this.energy;
    }
}

