/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.multiblock.tilemodule;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.vlib.api.multiblock.IControllerTile;
import com.valkyrieofnight.vlib.api.multiblock.ISlaveTile;
import com.valkyrieofnight.vlib.legacy.util.helpers.PlayerUtil;
import com.valkyrieofnight.vlib.lib.tilemodule.ITileModule;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class StructureFormer
implements ITileModule<StructureFormer> {
    protected int mbDirection = -1;
    private boolean isFormed = false;
    private UUID owner;
    private int ticker = 0;
    private TileEntity tile;
    private IControllerTile controller;

    public StructureFormer(TileEntity tile) {
        this.tile = tile;
        if (!(tile instanceof IControllerTile)) {
            throw new IllegalArgumentException("Tile must be of type IControllerTile");
        }
        this.controller = (IControllerTile)tile;
    }

    @Override
    public StructureFormer readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("isFormed")) {
            this.isFormed = nbt.func_74767_n("isFormed");
            this.mbDirection = nbt.func_74762_e("mbdir");
        }
        this.owner = PlayerUtil.readUUID(nbt.func_74775_l("profile"));
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.isFormed) {
            nbt.func_74757_a("isFormed", this.isFormed);
            nbt.func_74768_a("mbdir", this.mbDirection);
        }
        if (this.owner != null) {
            nbt.func_74782_a("profile", (NBTBase)PlayerUtil.writeUUID(this.owner, new NBTTagCompound()));
        }
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return null;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void onChunkUnload() {
    }

    @Override
    public void update() {
        if (!this.tile.func_145831_w().field_72995_K) {
            ++this.ticker;
            if (this.ticker % 60 == 0) {
                if (!this.isFormed) {
                    this.mbDirection = this.controller.getStructure().verifyLayout(this.tile.func_145831_w(), this.tile.func_174877_v());
                    if (this.mbDirection != -1) {
                        this.controller.getStructure().initStructure(this.tile.func_145831_w(), this.tile.func_174877_v(), this.controller.getStructure().getSlavesLayout(this.tile.func_145831_w(), this.tile.func_174877_v(), EnumFacing.func_82600_a((int)this.mbDirection)));
                        this.isFormed = true;
                    }
                }
                if (this.ticker > 6000) {
                    this.ticker = 0;
                }
            }
        }
    }

    public void deformMultiblock() {
        for (BlockPos p : this.controller.getStructure().getSlavesLayout(this.tile.func_145831_w(), this.tile.func_174877_v(), EnumFacing.func_82600_a((int)this.mbDirection))) {
            TileEntity te = this.tile.func_145831_w().func_175625_s(p);
            if (te == null || !(te instanceof ISlaveTile)) continue;
            ((ISlaveTile)te).removeController();
        }
        this.isFormed = false;
    }

    public void setOwner(GameProfile owner) {
        if (owner == null) {
            return;
        }
        this.owner = owner.getId();
    }

    public void setOwner(UUID plr) {
        this.owner = plr;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isFormed() {
        return this.isFormed;
    }

    public int getMBDirection() {
        return this.mbDirection;
    }

    public EnumFacing getMBDirectionE() {
        return EnumFacing.func_82600_a((int)this.mbDirection);
    }

    public void packetUpdateFormer(boolean formed) {
        this.isFormed = formed;
    }
}

