/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.multiblock;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.vlib.api.multiblock.IControllerTile;
import com.valkyrieofnight.vlib.api.multiblock.ISlaveTile;
import com.valkyrieofnight.vlib.lib.multiblock.tilemodule.StructureFormer;
import com.valkyrieofnight.vlib.lib.tile.energy.VLTileEnergyConsumer;
import com.valkyrieofnight.vlib.lib.tilemodule.progress.ITileProgress;
import com.valkyrieofnight.vlib.lib.tilemodule.progress.ProgressTracker;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class VLControllerEConsumer
extends VLTileEnergyConsumer
implements IControllerTile,
ITileProgress {
    protected ProgressTracker progress = new ProgressTracker();
    protected StructureFormer former = new StructureFormer(this);
    private long currentTick = 0L;

    public VLControllerEConsumer(int capacity) {
        this(capacity, capacity);
    }

    public VLControllerEConsumer(int capacity, int maxExtract) {
        super(capacity, maxExtract);
        this.addModule(this.former);
    }

    @Override
    public void func_73660_a() {
        if (this.getTheWorld().func_82737_E() == this.currentTick) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            // empty if block
        }
        this.currentTick = this.getTheWorld().func_72820_D();
        if (this.former.isFormed() && this.former.getMBDirection() != -1) {
            if (!this.func_145831_w().func_175640_z(this.func_174877_v())) {
                this.updateProgress();
            } else {
                this.onIdleTick();
            }
        }
        super.func_73660_a();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.progress.writeToNBT(nbt);
        this.former.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress.readFromNBT(nbt);
        this.former.readFromNBT(nbt);
    }

    @Override
    public String getInfo() {
        return "Owner: " + this.former.getOwner();
    }

    @Override
    public boolean isSlave(BlockPos pos) {
        return this.getStructure().getSlavesLayout(this.getTheWorld(), this.func_174877_v(), EnumFacing.func_82600_a((int)this.former.getMBDirection())).contains(pos);
    }

    @Override
    public void notifyChange(ISlaveTile slave, BlockPos pos) {
        this.deformMultiblock();
    }

    @Override
    public void deformMultiblock() {
        this.former.deformMultiblock();
    }

    @Override
    public boolean isFormed() {
        return this.former.isFormed();
    }

    @Override
    public UUID getOwner() {
        return this.former.getOwner();
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.former.setOwner(owner);
    }

    @Override
    public ProgressTracker getTracker() {
        return this.progress;
    }

    @Override
    public World getTheWorld() {
        return this.field_145850_b;
    }

    @Override
    public EnumFacing getDirectionE() {
        return this.former.getMBDirectionE();
    }

    @Override
    public int getCurrentDuration() {
        int duration = (int)((float)this.getBaseDuration());
        if ((duration = this.modifyDuration(duration)) < this.getMinDuration()) {
            return this.getMinDuration();
        }
        if (duration > this.getMaxDuration()) {
            return this.getMaxDuration();
        }
        return duration;
    }

    @Override
    public boolean canStartProcess() {
        return this.isFormed();
    }

    @Override
    public int canProcess(int ticks) {
        return this.canProcess() ? 1 : 0;
    }

    @Override
    public int processTicks() {
        return 1;
    }

    @Override
    public void serverUpdate() {
    }

    @Override
    public void clientUpdate() {
    }

    public abstract int getBaseDuration();

    public abstract int getMinDuration();

    public abstract int getMaxDuration();

    public abstract int modifyDuration(int var1);

    public abstract boolean canProcess();
}

