/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.client.gui.elements;

import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiDraw;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiDrawTooltip;
import com.valkyrieofnight.vlib.lib.client.gui.elements.VLElement;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class VLElementItemStackList
extends VLElement
implements IGuiDraw,
IGuiDrawTooltip {
    protected List<ItemStack> stacks;
    protected float currentPartialTick = 0.0f;
    protected int ticksPerItem = 20;
    protected int currentItem = 0;
    protected boolean drawToolTip = true;

    public VLElementItemStackList(String elementID, int x, int y, List<ItemStack> stacks) {
        super(elementID);
        this.xPosOffset = x;
        this.yPosOffset = y;
        this.stacks = stacks;
        this.xSize = 16;
        this.ySize = 16;
    }

    public void setDrawToolTip(boolean opt) {
        this.drawToolTip = opt;
    }

    public VLElementItemStackList setTicksPerItem(int t) {
        this.ticksPerItem = t;
        return this;
    }

    @Override
    public void drawBackgroundLayer(int mx, int my, float partialTicks) {
        this.currentPartialTick += partialTicks;
        if (this.currentPartialTick >= (float)this.ticksPerItem) {
            this.currentPartialTick = 0.0f;
            ++this.currentItem;
            if (this.currentItem >= this.stacks.size()) {
                this.currentItem = 0;
            }
        }
        if (this.stacks == null && this.stacks.size() <= 0) {
            return;
        }
        if (this.stacks.size() > this.currentItem) {
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(this.stacks.get(this.currentItem), this.getXPosActual(), this.getYPosActual());
            RenderHelper.func_74518_a();
        }
    }

    @Override
    public void drawForegroundLayer(int mx, int my, float partialTicks) {
    }

    @Override
    public int getXSize() {
        return 16;
    }

    @Override
    public int getYSize() {
        return 16;
    }

    @Override
    public void setXSize(int xSize) {
    }

    @Override
    public void setYSize(int ySize) {
    }

    @Override
    public void init() {
    }

    @Override
    public void addToolTip(String localizedToolTip) {
    }

    @Override
    public void setToolTipList(List<String> toolTips) {
    }

    @Override
    public void drawToolTip(int mx, int my) {
        if (!this.drawToolTip) {
            return;
        }
        if (this.gui.isInBoxAndGUI(mx, my, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize())) {
            this.gui.drawHoverText(this.stacks.get(this.currentItem).func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)), mx, my);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return nbt;
    }
}

