/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.block;

import com.google.common.collect.ImmutableList;
import com.valkyrieofnight.vlib.legacy.util.helpers.ChatHelper;
import com.valkyrieofnight.vlib.legacy.util.helpers.LanguageHelper;
import com.valkyrieofnight.vlib.lib.init.IModNamespace;
import com.valkyrieofnight.vlib.lib.init.IRegisterCustomItemBlock;
import com.valkyrieofnight.vlib.lib.init.client.IRegisterModels;
import com.valkyrieofnight.vlib.lib.item.VLItemBlock;
import com.valkyrieofnight.vlib.lib.tilemodule.IInfoTile;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;

public abstract class VLBlock
extends Block
implements IRegisterModels,
IRegisterCustomItemBlock,
IModNamespace {
    protected VLItemBlock itemBlock;
    protected boolean playerBreakOnly = false;

    public VLBlock(Material materialIn) {
        super(materialIn);
    }

    public VLBlock(Material mat, boolean playerBreakOnly) {
        super(mat);
        this.playerBreakOnly = playerBreakOnly;
    }

    @Override
    public ItemBlock getItemBlock() {
        if (this.itemBlock == null) {
            this.itemBlock = new VLItemBlock(this);
        }
        this.itemBlock.setRarity(this.getRarity(), 0);
        if (this.playerBreakOnly()) {
            this.addToolTipLocalized(LanguageHelper.toLoc("tooltip.valkyrielib.witherproof"));
            this.addToolTipLocalized(LanguageHelper.toLoc("tooltip.valkyrielib.playerbreakonly"));
        }
        return this.itemBlock;
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void addToolTipLocalized(String str) {
        if (this.itemBlock != null) {
            this.itemBlock.addToolTipLocalized(str);
        }
    }

    public boolean playerBreakOnly() {
        return this.playerBreakOnly;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (this.playerBreakOnly()) {
            return entity instanceof EntityPlayer;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public EnumRarity getRarity() {
        return EnumRarity.COMMON;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!this.playerBreakOnly()) {
            world.func_175698_g(pos);
            this.func_180652_a(world, pos, explosion);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        if (this.playerBreakOnly()) {
            return false;
        }
        return super.func_149659_a(explosionIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && this instanceof ITileEntityProvider && (te = worldIn.func_175625_s(pos)) instanceof IInfoTile) {
            String mess = ((IInfoTile)te).getInfo();
            ChatHelper.noSpamServer(playerIn, (List<ITextComponent>)ImmutableList.of((Object)new TextComponentString(mess)));
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public VLBlock setHarvest(String harvestTool, int harvestLevel) {
        this.setHarvestLevel(harvestTool, harvestLevel);
        return this;
    }

    public float getHardness() {
        return this.field_149782_v;
    }

    public float getResistance() {
        return this.field_149781_w;
    }

    public SoundType getBlockSoundType() {
        return this.field_149762_H;
    }
}

