/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.um.api.base.attributes;

import com.valkyrieofnight.um.api.attribute.AAttributeCalculator;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.IAttribute;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class AttributeTotalLevel
implements IAttribute<Integer> {
    public static final Class CALCULATOR_CLASS = ACalcTotalLevel.class;
    protected AttributeID attributeID;
    protected int level;

    public AttributeTotalLevel(AttributeID attributeID, int level) {
        this.attributeID = attributeID;
        this.level = level;
    }

    public AttributeTotalLevel(int level) {
        this.level = level;
    }

    @Override
    public AttributeID getAttributeID() {
        return this.attributeID;
    }

    @Override
    public Integer getValue() {
        return this.level;
    }

    public static final class ACalcTotalLevel
    extends AAttributeCalculator<AttributeTotalLevel, Integer, Integer, Integer> {
        @Override
        public Integer calculateFinalValue(List<IAttribute<Integer>> attributes) {
            int total = 0;
            for (IAttribute<Integer> iAttribute : attributes) {
                total += iAttribute.getValue().intValue();
            }
            return total;
        }

        @Override
        public Integer calculateModifiedValue(Integer attributeFinalValue, Integer unmodifiedValue) {
            return attributeFinalValue + unmodifiedValue;
        }

        @Override
        public Object readFinalValueFromNBT(NBTTagCompound nbt) {
            return nbt.func_74762_e(this.getAttribute().toString());
        }

        @Override
        public NBTTagCompound writeFinalValueToNBT(NBTTagCompound nbt, Object obj) {
            Integer data = (Integer)obj;
            nbt.func_74768_a(this.getAttribute().toString(), data.intValue());
            return nbt;
        }
    }
}

