/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.um.api.base.attributes;

import com.valkyrieofnight.um.api.attribute.AAttributeCalculator;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.IAttribute;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class AttributeForgeEnergyFixed
implements IAttribute<Integer> {
    public static AttributeID FORGE_ENERGY_FIXED = new AttributeID("universalmodifiers", "fe_fixed", ACalcForgeEnergyFixed.class);
    protected int energyCost;

    public AttributeForgeEnergyFixed(int energyCost) {
        this.energyCost = energyCost;
    }

    @Override
    public AttributeID getAttributeID() {
        return FORGE_ENERGY_FIXED;
    }

    @Override
    public Integer getValue() {
        return this.energyCost;
    }

    public static final class ACalcForgeEnergyFixed
    extends AAttributeCalculator<AttributeForgeEnergyFixed, Integer, Integer, Integer> {
        @Override
        public Integer calculateFinalValue(List<IAttribute<Integer>> attributes) {
            int total = 0;
            for (IAttribute<Integer> iAttribute : attributes) {
                total += iAttribute.getValue().intValue();
            }
            return total;
        }

        @Override
        public Integer calculateModifiedValue(Integer attributeFinalValue, Integer unmodifiedValue) {
            return attributeFinalValue + unmodifiedValue;
        }

        @Override
        public Object readFinalValueFromNBT(NBTTagCompound nbt) {
            return nbt.func_74762_e(this.getAttribute().toString());
        }

        @Override
        public NBTTagCompound writeFinalValueToNBT(NBTTagCompound nbt, Object obj) {
            Integer data = (Integer)obj;
            nbt.func_74768_a(this.getAttribute().toString(), data.intValue());
            return nbt;
        }
    }
}

