/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeJEI;

public abstract class CommonEnvironmentalAccumulatorRecipeCategory
implements IRecipeCategory {
    private final Map<WeatherType, IDrawableStatic> weatherIcons;
    private final Pair<Integer, Integer> weatherInPos;
    private final Pair<Integer, Integer> weatherOutPos;
    private EnvironmentalAccumulatorRecipeJEI lastRecipe = null;

    public CommonEnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper, Pair<Integer, Integer> weatherInPos, Pair<Integer, Integer> weatherOutPos) {
        this.weatherInPos = weatherInPos;
        this.weatherOutPos = weatherOutPos;
        this.weatherIcons = Maps.newHashMap();
        ResourceLocation weatherResourceLocation = new ResourceLocation("evilcraft:textures/gui/weathers.png");
        this.weatherIcons.put(WeatherType.CLEAR, guiHelper.createDrawable(weatherResourceLocation, 0, 0, 16, 16));
        this.weatherIcons.put(WeatherType.RAIN, guiHelper.createDrawable(weatherResourceLocation, 16, 0, 16, 16));
        this.weatherIcons.put(WeatherType.LIGHTNING, guiHelper.createDrawable(weatherResourceLocation, 32, 0, 16, 16));
    }

    public String getModName() {
        return "EvilCraft";
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(Minecraft minecraft) {
        if (this.lastRecipe != null) {
            if (this.lastRecipe.getInputWeather() != WeatherType.ANY) {
                this.weatherIcons.get(this.lastRecipe.getInputWeather()).draw(minecraft, ((Integer)this.weatherInPos.getLeft()).intValue(), ((Integer)this.weatherInPos.getRight()).intValue());
            }
            if (this.lastRecipe.getOutputWeather() != WeatherType.ANY) {
                this.weatherIcons.get(this.lastRecipe.getOutputWeather()).draw(minecraft, ((Integer)this.weatherOutPos.getLeft()).intValue(), ((Integer)this.weatherOutPos.getRight()).intValue());
            }
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        EnvironmentalAccumulatorRecipeJEI recipe;
        this.lastRecipe = recipeWrapper instanceof EnvironmentalAccumulatorRecipeJEI ? (recipe = (EnvironmentalAccumulatorRecipeJEI)recipeWrapper) : null;
    }
}

