/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;

public class WorldSharedTank
extends SingleUseTank {
    public static final String NBT_TANKID = "tankID";
    protected String tankID = "";
    private int previousAmount = 0;

    public WorldSharedTank(String name, int capacity, CyclopsTileEntity tile) {
        super(name, capacity, tile);
        this.tile = tile;
    }

    public void resetPreviousFluid() {
        this.previousAmount = this.getFluidAmount();
    }

    public int getPreviousAmount() {
        return this.previousAmount;
    }

    public void writeTankToNBT(NBTTagCompound nbt) {
        super.writeTankToNBT(nbt);
        nbt.func_74778_a(NBT_TANKID, this.tankID);
    }

    public void readTankFromNBT(NBTTagCompound nbt) {
        super.readTankFromNBT(nbt);
        this.tankID = nbt.func_74779_i(NBT_TANKID);
    }

    protected void readWorldFluid() {
        this.fluid = WorldSharedTankCache.getInstance().getTankContent(this.tankID);
    }

    protected void writeWorldFluid() {
        if (!MinecraftHelpers.isClientSide()) {
            WorldSharedTankCache.getInstance().setTankContent(this.tankID, this.fluid);
        }
    }

    public void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
        this.writeWorldFluid();
    }

    public FluidStack getFluid() {
        this.readWorldFluid();
        return super.getFluid();
    }

    public int getFluidAmount() {
        this.readWorldFluid();
        return super.getFluidAmount();
    }

    public int fill(FluidStack resource, boolean doFill) {
        this.readWorldFluid();
        int ret = super.fill(resource, doFill);
        if (ret > 0 && doFill) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        this.readWorldFluid();
        FluidStack ret = super.drain(maxDrain, doDrain);
        if (ret != null && doDrain) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        this.readWorldFluid();
        FluidStack ret = super.drain(resource, doDrain);
        if (ret != null && doDrain) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public String getTankID() {
        return this.tankID;
    }

    public void setTankID(String tankID) {
        this.tankID = tankID;
    }

    public Fluid getAcceptedFluid() {
        return this.getFluidType();
    }

    protected boolean replaceInnerFluid() {
        return false;
    }

    public static class TankData
    extends WorldStorage {
        public static final String KEY = "WorldSharedTanks";

        public TankData(ModBase mod) {
            super(mod);
        }

        public void reset() {
            WorldSharedTankCache.getInstance().reset();
        }

        protected String getDataId() {
            return KEY;
        }

        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            WorldSharedTankCache.getInstance().readFromNBT(tag);
        }

        public void writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            WorldSharedTankCache.getInstance().writeToNBT(tag);
        }
    }
}

